
# HireCameroon Deployment Checklist

## 🚀 Pre-Deployment Setup

### 1. Git Repository Setup
- [ ] Repository: https://github.com/aloahmilton/hirecameroon.git
- [ ] Create `main` branch (production)
- [ ] Create `staging` branch (testing)
- [ ] Create `develop` branch (development)

### 2. GitHub Secrets Configuration
Navigate to: https://github.com/aloahmilton/hirecameroon/settings/secrets/actions

#### Staging Environment Secrets:
```
STAGING_HOST=your-staging-server-ip
STAGING_USER=your-staging-ssh-username
STAGING_SSH_KEY=your-staging-ssh-private-key
```

#### Production Environment Secrets:
```
PROD_HOST=your-production-server-ip
PROD_USER=your-production-ssh-username
PROD_SSH_KEY=your-production-ssh-private-key
PROD_DB_HOST=your-production-db-host
PROD_DB_USER=your-production-db-username
PROD_DB_PASSWORD=your-production-db-password
PROD_DB_NAME=your-production-db-name
```

#### Additional Secrets:
```
AWS_S3_BACKUP_BUCKET=your-backup-bucket-name
CLOUDFRONT_DISTRIBUTION_ID=your-cloudfront-id
DOCKER_USERNAME=your-dockerhub-username
DOCKER_PASSWORD=your-dockerhub-password
```

### 3. Server Setup Checklist

#### Staging Server Requirements:
- [ ] Ubuntu 20.04+ or CentOS 8+
- [ ] PHP 8.2 with required extensions
- [ ] MySQL 8.0+ or MariaDB 10.6+
- [ ] Nginx or Apache
- [ ] SSL certificate (Let's Encrypt)
- [ ] SSH access configured
- [ ] Database created and user configured

#### Production Server Requirements:
- [ ] Same as staging plus:
- [ ] Redis (optional, for caching)
- [ ] SSL certificate configured
- [ ] CDN setup (CloudFront)
- [ ] Monitoring tools (optional)

### 4. Environment Configuration

#### .env.staging file:
```env
APP_NAME=HireCameroon
APP_ENV=staging
APP_KEY=base64-generated-key
APP_DEBUG=false
APP_URL=https://staging.hirecameroon.com

DB_CONNECTION=mysql
DB_HOST=staging-db-host
DB_PORT=3306
DB_DATABASE=hirecameroon_staging
DB_USERNAME=staging-db-user
DB_PASSWORD=staging-db-password

MAIL_MAILER=smtp
MAIL_HOST=your-smtp-host
MAIL_PORT=587
MAIL_USERNAME=your-email
MAIL_PASSWORD=your-email-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@hirecameroon.com
MAIL_FROM_NAME="HireCameroon"

# Mesomb Payment Configuration
MESOMB_APPLICATION_KEY=your-mesomb-app-key
MESOMB_ACCESS_KEY=your-mesomb-access-key
MESOMB_SECRET_KEY=your-mesomb-secret-key
```

#### .env.production file:
```env
APP_NAME=HireCameroon
APP_ENV=production
APP_KEY=base64-generated-key
APP_DEBUG=false
APP_URL=https://hirecameroon.com

DB_CONNECTION=mysql
DB_HOST=production-db-host
DB_PORT=3306
DB_DATABASE=hirecameroon_prod
DB_USERNAME=production-db-user
DB_PASSWORD=production-db-password

MAIL_MAILER=smtp
MAIL_HOST=your-smtp-host
MAIL_PORT=587
MAIL_USERNAME=your-email
MAIL_PASSWORD=your-email-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@hirecameroon.com
MAIL_FROM_NAME="HireCameroon"

# Mesomb Payment Configuration
MESOMB_APPLICATION_KEY=your-mesomb-app-key
MESOMB_ACCESS_KEY=your-mesomb-access-key
MESOMB_SECRET_KEY=your-mesomb-secret-key

# AWS Configuration (for backups)
AWS_ACCESS_KEY_ID=your-aws-key
AWS_SECRET_ACCESS_KEY=your-aws-secret
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=your-backup-bucket
```

## 🔧 Deployment Steps

### Step 1: Initial Repository Setup
```bash
# Clone the repository
git clone https://github.com/aloahmilton/hirecameroon.git
cd hirecameroon

# Create branches
git checkout -b main
git checkout -b staging
git checkout -b develop

# Push branches to GitHub
git push -u origin main staging develop
```

### Step 2: Configure GitHub Environments
1. Go to: https://github.com/aloahmilton/hirecameroon/settings/environments
2. Create "staging" environment
3. Create "production" environment
4. Add required secrets to each environment

### Step 3: Server Preparation

#### Install Required Software on Servers:
```bash
# Update system
sudo apt update && sudo apt upgrade -y

# Install PHP 8.2 and extensions
sudo apt install php8.2 php8.2-cli php8.2-fpm php8.2-mysql php8.2-xml php8.2-mbstring php8.2-curl php8.2-zip php8.2-intl php8.2-gd -y

# Install Composer
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Install Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# Install Nginx
sudo apt install nginx -y

# Install MySQL
sudo apt install mysql-server -y
sudo mysql_secure_installation
```

#### Database Setup:
```sql
-- Create databases
CREATE DATABASE hirecameroon_staging CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE DATABASE hirecameroon_prod CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Create users
CREATE USER 'hirecameroon_staging'@'localhost' IDENTIFIED BY 'strong-password';
CREATE USER 'hirecameroon_prod'@'localhost' IDENTIFIED BY 'strong-password';

-- Grant permissions
GRANT ALL PRIVILEGES ON hirecameroon_staging.* TO 'hirecameroon_staging'@'localhost';
GRANT ALL PRIVILEGES ON hirecameroon_prod.* TO 'hirecameroon_prod'@'localhost';

FLUSH PRIVILEGES;
```

#### Nginx Configuration:
```nginx
# /etc/nginx/sites-available/hirecameroon
server {
    listen 80;
    server_name staging.hirecameroon.com;
    root /var/www/hirecameroon-staging/public;
    index index.php index.html;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        include snippets/fastcgi-php.conf;
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
    }

    location ~ /\.ht {
        deny all;
    }
}
```

### Step 4: SSH Key Setup
```bash
# Generate SSH key pair (on local machine)
ssh-keygen -t rsa -b 4096 -C "deploy@hirecameroon.com"

# Copy public key to servers
ssh-copy-id user@staging-server
ssh-copy-id user@production-server

# Test SSH connection
ssh user@staging-server
ssh user@production-server
```

### Step 5: SSL Certificate Setup
```bash
# Install Certbot
sudo apt install certbot python3-certbot-nginx -y

# Get SSL certificates
sudo certbot --nginx -d staging.hirecameroon.com
sudo certbot --nginx -d hirecameroon.com
```

## 🧪 Testing Checklist

### Pre-Deployment Tests:
- [ ] Run `php artisan test` - All tests pass
- [ ] Run `php artisan migrate:status` - All migrations ready
- [ ] Run `npm run build` - Assets compile successfully
- [ ] Check `.env` files are properly configured
- [ ] Verify database connections work
- [ ] Test email sending functionality
- [ ] Test payment integration (Mesomb)

### Staging Deployment Test:
- [ ] Push to `staging` branch triggers deployment
- [ ] Application loads correctly on staging
- [ ] Database migrations run successfully
- [ ] Admin login works (admin@hirecameroon.com / admin123)
- [ ] User registration and login work
- [ ] Job posting and application work
- [ ] Payment processing works
- [ ] All features functional

### Production Deployment Test:
- [ ] Create and push version tag (e.g., `v1.0.0`)
- [ ] Production deployment triggers automatically
- [ ] Application loads on production domain
- [ ] SSL certificate works
- [ ] CDN integration works
- [ ] Database backup created before deployment
- [ ] All functionality verified

## 🚨 Emergency Rollback

### If Something Goes Wrong:
1. **Immediate Rollback**: Use GitHub's deployment rollback feature
2. **Database Rollback**: `php artisan migrate:rollback --step=1`
3. **Code Rollback**: `git revert <commit-hash>`
4. **Cache Clear**: `php artisan cache:clear && php artisan config:clear`

## 📊 Monitoring Setup

### Recommended Monitoring:
- [ ] Server monitoring (CPU, RAM, Disk)
- [ ] Application monitoring (response times, errors)
- [ ] Database monitoring (connections, slow queries)
- [ ] SSL certificate monitoring
- [ ] Uptime monitoring
- [ ] Error logging and alerting

## 🎯 Go-Live Checklist

- [ ] All pre-deployment tests pass
- [ ] Staging environment fully tested
- [ ] Production secrets configured
- [ ] SSL certificates active
- [ ] Domain DNS configured
- [ ] CDN configured (if using)
- [ ] Backup systems operational
- [ ] Monitoring systems active
- [ ] Support contact information ready
- [ ] Emergency rollback procedures documented

## 📞 Support Contacts

- **Technical Support**: [Your contact info]
- **Domain Registrar**: [Registrar contact]
- **Hosting Provider**: [Hosting contact]
- **Payment Provider**: [Mesomb support]

---

**Remember**: Always test thoroughly on staging before deploying to production!</result>
<line_count>300</line_count>
</write_to_file>