<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SavedSearchController extends Controller
{
    public function store(Request $request)
    {
        $user = $request->user();

        $data = $request->validate([
            'query' => 'nullable|string',
            'location' => 'nullable|string',
            'sector' => 'nullable|string',
            'experience_level' => 'nullable|string',
            'employment_type' => 'nullable|string',
            'salary_min' => 'nullable|integer',
            'salary_max' => 'nullable|integer',
            'remote' => 'nullable|string',
            'featured' => 'nullable|string',
        ]);

        DB::table('saved_searches')->insert([
            'user_id' => $user->id,
            'filters' => json_encode($data),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['success' => true]);
    }
}


