<?php

namespace App\Http\Controllers;

use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReviewController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'role' => 'nullable|string|max:255',
            'content' => 'required|string|min:10|max:1000',
            'rating' => 'required|integer|min:1|max:5',
            'user_type' => 'required|in:job_seeker,employer',
        ]);

        // use input() to access request data or use validated data to avoid protected property access
        $review = Review::create([
            'user_id' => Auth::id(),
            'name' => $request->input('name'),
            'role' => $request->input('role'),
            'content' => $request->input('content'),
            'rating' => $request->input('rating'),
            'user_type' => $request->input('user_type'),
            'is_published' => false, // Admin approval required
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Review submitted successfully. It will be published after admin approval.',
            'review' => $review
        ]);
    }

    public function index()
    {
        $reviews = Review::published()
            ->featured()
            ->orderBy('created_at', 'desc')
            ->limit(6)
            ->get();

        return view('reviews.index', compact('reviews'));
    }
}
