<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'days', 'price_cents', 'priority_weight', 'description',
    ];

    protected $casts = [
        'days' => 'integer',
        'price_cents' => 'integer',
        'priority_weight' => 'integer',
    ];

    public function ads()
    {
        return $this->hasMany(Ad::class);
    }
}
