<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'description', 'owner_user_id', 'logo_path',
        'color_primary', 'color_secondary', 'sector', 'registration_no',
        'company_size', 'website', 'location', 'size', 'founded_year',
        'tax_id', 'business_license', 'num_offices', 'ceo_name', 'contact_person',
        'contact_email', 'contact_phone', 'facebook_url', 'twitter_url',
        'linkedin_url', 'instagram_url', 'company_values', 'benefits_offered',
        'career_development', 'achievements', 'certifications', 'partnerships',
        'industry_experience', 'target_market', 'revenue_range', 'business_model'
    ];

    public function owner()
    {
        return $this->belongsTo(User::class, 'owner_user_id');
    }

    /**
     * Get the jobs for the company.
     */
    public function jobs()
    {
        return $this->hasMany(Job::class);
    }

    /**
     * Get the applications for the company through jobs.
     */
    public function applications()
    {
        return $this->hasManyThrough(Application::class, Job::class);
    }

    /**
     * Accessor to match view expectation `$company->logo` while storing `logo_path`.
     */
    public function getLogoAttribute(): ?string
    {
        return $this->logo_path;
    }
}


