<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class JobComment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'job_id',
        'comment',
        'parent_id',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function job(): BelongsTo
    {
        return $this->belongsTo(Job::class);
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(JobComment::class, 'parent_id');
    }

    public function replies(): HasMany
    {
        return $this->hasMany(JobComment::class, 'parent_id');
    }

    public function scopeTopLevel($query)
    {
        return $query->whereNull('parent_id');
    }
}
