<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SystemHealthLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'cpu_usage',
        'memory_usage',
        'memory_used_mb',
        'memory_total_mb',
        'disk_usage',
        'disk_used_gb',
        'disk_total_gb',
        'active_sessions',
        'response_time_ms',
        'error_count',
        'services_status',
        'additional_metrics',
    ];

    protected $casts = [
        'cpu_usage' => 'decimal:2',
        'memory_usage' => 'decimal:2',
        'memory_used_mb' => 'decimal:2',
        'memory_total_mb' => 'decimal:2',
        'disk_usage' => 'decimal:2',
        'disk_used_gb' => 'decimal:2',
        'disk_total_gb' => 'decimal:2',
        'response_time_ms' => 'decimal:2',
        'services_status' => 'array',
        'additional_metrics' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function scopeRecent($query, $hours = 24)
    {
        return $query->where('created_at', '>=', now()->subHours($hours));
    }

    public function scopeLastHour($query)
    {
        return $query->where('created_at', '>=', now()->subHour());
    }

    public function getHealthStatusAttribute()
    {
        $issues = [];

        if ($this->cpu_usage > 90) $issues[] = 'High CPU usage';
        if ($this->memory_usage > 90) $issues[] = 'High memory usage';
        if ($this->disk_usage > 90) $issues[] = 'Low disk space';
        if ($this->error_count > 10) $issues[] = 'High error rate';
        if ($this->response_time_ms > 2000) $issues[] = 'Slow response time';

        return [
            'status' => empty($issues) ? 'healthy' : 'warning',
            'issues' => $issues
        ];
    }
}
