<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class AdExpired extends Notification
{
    use Queueable;

    public $ad;

    public function __construct($ad)
    {
        $this->ad = $ad;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Your advertisement has expired')
            ->greeting('Hello!')
            ->line('Your advertisement "' . ($this->ad->title ?? 'Ad') . '" has expired.')
            ->action('Repost Ad', url('/ads/' . ($this->ad->id ?? '') . '/repost'))
            ->line('Thank you for using our platform.');
    }

    public function toArray($notifiable)
    {
        return [
            'ad_id' => $this->ad->id ?? null,
            'title' => $this->ad->title ?? null,
            'message' => 'Your ad has expired',
        ];
    }
}
