<?php

namespace App\View\Components;

use App\Services\AdService;
use Illuminate\View\Component;

class AdDisplay extends Component
{
    public $position;
    public $ads;

    public function __construct(string $position = 'sidebar')
    {
        $this->position = $position;
        $adService = app(AdService::class);
        $this->ads = $adService->getActiveAds($position);
    }

    public function render()
    {
        return view('components.ad-display');
    }

    public function shouldRender()
    {
        return count($this->ads) > 0;
    }
}