<?php

namespace App\View\Components\Ads;

use Illuminate\View\Component;

abstract class BaseAd extends Component
{
    public $shouldShow = true;

    public function __construct($hideFor = null)
    {
        // Don't show ads for premium users if specified
        if ($hideFor === 'premium' && auth()->check() && auth()->user()->is_premium) {
            $this->shouldShow = false;
        }

        // Don't show ads in admin area
        if (request()->is('admin/*')) {
            $this->shouldShow = false;
        }
    }
}