<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Unified Communication System
    |--------------------------------------------------------------------------
    |
    | This configuration manages all communication channels (Email, SMS, Push)
    | with multiple provider support and admin-controlled settings.
    |
    */

    'default' => env('COMMUNICATION_DEFAULT', 'email'),

    'providers' => [
        'email' => [
            'default' => env('EMAIL_PROVIDER', 'smtp'),
            'options' => ['smtp', 'phpmailer', 'mailgun', 'ses', 'postmark'],
        ],
        'sms' => [
            'default' => env('SMS_PROVIDER', 'twilio'),
            'options' => ['twilio', 'messagebird', 'nexmo', 'africatalking'],
        ],
        'push' => [
            'default' => env('PUSH_PROVIDER', 'firebase'),
            'options' => ['firebase', 'pusher', 'one_signal'],
        ],
    ],

    'settings' => [
        'email' => [
            'smtp' => [
                'host' => env('MAIL_HOST'),
                'port' => env('MAIL_PORT', 587),
                'encryption' => env('MAIL_ENCRYPTION', 'tls'),
                'username' => env('MAIL_USERNAME'),
                'password' => env('MAIL_PASSWORD'),
                'timeout' => env('MAIL_TIMEOUT', 30),
            ],
            'phpmailer' => [
                'smtp_host' => env('PHPMAILER_SMTP_HOST'),
                'smtp_port' => env('PHPMAILER_SMTP_PORT', 587),
                'smtp_encryption' => env('PHPMAILER_SMTP_ENCRYPTION', 'tls'),
                'smtp_username' => env('PHPMAILER_SMTP_USERNAME'),
                'smtp_password' => env('PHPMAILER_SMTP_PASSWORD'),
                'sendmail_path' => env('PHPMAILER_SENDMAIL_PATH', '/usr/sbin/sendmail -bs -i'),
                'is_html' => env('PHPMAILER_IS_HTML', true),
            ],
        ],
        'sms' => [
            'twilio' => [
                'sid' => env('TWILIO_SID'),
                'token' => env('TWILIO_TOKEN'),
                'from' => env('TWILIO_FROM'),
            ],
            'messagebird' => [
                'api_key' => env('MESSAGEBIRD_API_KEY'),
                'originator' => env('MESSAGEBIRD_ORIGINATOR'),
            ],
            'nexmo' => [
                'api_key' => env('NEXMO_API_KEY'),
                'api_secret' => env('NEXMO_API_SECRET'),
                'from' => env('NEXMO_FROM'),
            ],
            'africatalking' => [
                'username' => env('AFRICATALKING_USERNAME'),
                'api_key' => env('AFRICATALKING_API_KEY'),
                'from' => env('AFRICATALKING_FROM'),
            ],
        ],
    ],

    'templates' => [
        'application_status' => 'emails.application-status-updated',
        'welcome' => 'emails.welcome',
        'password_reset' => 'emails.password-reset',
        'job_alert' => 'emails.job-alert',
        'subscription_notice' => 'emails.subscription-notice',
        'admin_notification' => 'emails.admin-notification',
    ],

    'sms_templates' => [
        'application_status' => 'Your application status has been updated: {status}',
        'password_reset' => 'Your password reset code is: {code}',
        'job_alert' => 'New job matching your criteria: {title} at {company}',
        'subscription_notice' => 'Your subscription expires in {days} days',
    ],

    'queue' => [
        'enabled' => env('COMMUNICATION_QUEUE_ENABLED', true),
        'connection' => env('COMMUNICATION_QUEUE_CONNECTION', 'redis'),
    ],

    'logging' => [
        'enabled' => env('COMMUNICATION_LOGGING_ENABLED', true),
        'channel' => env('COMMUNICATION_LOG_CHANNEL', 'stack'),
    ],

    'throttling' => [
        'emails_per_hour' => env('EMAIL_THROTTLE_PER_HOUR', 100),
        'sms_per_hour' => env('SMS_THROTTLE_PER_HOUR', 20),
        'cooldown_minutes' => env('COOLDOWN_MINUTES', 5),
    ],

    'admin' => [
        'email_notifications' => env('ADMIN_EMAIL_NOTIFICATIONS', true),
        'sms_notifications' => env('ADMIN_SMS_NOTIFICATIONS', false),
        'weekly_reports' => env('ADMIN_WEEKLY_REPORTS', true),
        'critical_alerts' => env('ADMIN_CRITICAL_ALERTS', true),
    ],
];