<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Company>
 */
class CompanyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => fake()->company(),
            'description' => fake()->paragraphs(2, true),
            'owner_user_id' => null, // Will be set when creating companies for users
            'logo_path' => null,
            'color_primary' => fake()->hexColor(),
            'color_secondary' => fake()->hexColor(),
            'sector' => fake()->randomElement([
                'technology', 'finance', 'healthcare', 'education', 'retail',
                'logistics', 'manufacturing', 'construction', 'agriculture', 'energy'
            ]),
            'registration_no' => fake()->unique()->numerify('REG-#####'),
        ];
    }
}