<?php

namespace Database\Factories;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Job>
 */
class JobFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $cities = ['Douala', 'Yaoundé', 'Limbé', 'Bafoussam', 'Bamenda', 'Garoua', 'Maroua', 'Ngaoundéré'];
        $regions = ['Littoral', 'Centre', 'Southwest', 'West', 'Northwest', 'North', 'Far North', 'Adamawa'];

        $salaryMin = fake()->numberBetween(50000, 200000);
        $salaryMax = fake()->numberBetween($salaryMin, $salaryMin * 2);

        $jobTitles = [
            'Software Developer',
            'Marketing Manager',
            'Financial Analyst',
            'Project Manager',
            'Data Analyst',
            'Sales Representative',
            'Customer Service Agent',
            'Human Resources Specialist',
            'Graphic Designer',
            'Accountant',
            'Mechanical Engineer',
            'Nurse',
            'Teacher',
            'Chef',
            'Driver',
            'Security Guard',
            'Receptionist',
            'IT Support Specialist',
            'Business Analyst',
            'Content Writer'
        ];

        $jobTypes = ['full-time', 'part-time', 'contract', 'freelance', 'internship'];
        $experienceLevels = ['entry', 'mid', 'senior', 'executive'];

        return [
            'company_id' => Company::factory(),
            'title' => fake()->randomElement($jobTitles),
            'description' => $this->generateRealisticDescription(),
            'requirements' => $this->generateRealisticRequirements(),
            'responsibilities' => $this->generateRealisticResponsibilities(),
            'benefits' => $this->generateRealisticBenefits(),
            'location_city' => fake()->randomElement($cities),
            'location_region' => fake()->randomElement($regions),
            'job_type' => fake()->randomElement($jobTypes),
            'experience_level' => fake()->randomElement($experienceLevels),
            'salary_min' => $salaryMin,
            'salary_max' => $salaryMax,
            'sector_type' => fake()->randomElement([
                'technology', 'finance', 'healthcare', 'education', 'retail',
                'logistics', 'manufacturing', 'construction', 'agriculture', 'energy'
            ]),
            'status' => 'active',
            'verification_status' => 'pending',
            'tags' => $this->generateRelevantTags(),
        ];
    }

    private function generateRealisticDescription()
    {
        $templates = [
            "We are seeking a talented {title} to join our growing team. In this role, you will be responsible for {responsibility}. Our ideal candidate has {requirement} and is passionate about {industry}.",
            "Join our dynamic company as a {title}! We're looking for someone who can {responsibility} and bring {skill} to our team. This position offers {benefit} and the opportunity to work in a {environment}.",
            "Are you a {title} with experience in {skill}? We're hiring! This role involves {responsibility} and requires {requirement}. You'll work with a team of {team_size} professionals in our {location} office.",
        ];

        return fake()->randomElement($templates);
    }

    private function generateRealisticRequirements()
    {
        $requirements = [
            "Bachelor's degree in relevant field",
            "2+ years of experience",
            "Proficiency in Microsoft Office",
            "Strong communication skills",
            "Ability to work independently",
            "Team collaboration experience",
            "Problem-solving abilities",
            "Customer service orientation",
            "Attention to detail",
            "Time management skills"
        ];

        return implode("\n", fake()->randomElements($requirements, fake()->numberBetween(3, 6)));
    }

    private function generateRealisticResponsibilities()
    {
        $responsibilities = [
            "Manage daily operations",
            "Coordinate with team members",
            "Handle customer inquiries",
            "Prepare reports and documentation",
            "Maintain quality standards",
            "Assist in project planning",
            "Conduct research and analysis",
            "Provide training and support",
            "Monitor performance metrics",
            "Ensure compliance with policies"
        ];

        return implode("\n", fake()->randomElements($responsibilities, fake()->numberBetween(4, 8)));
    }

    private function generateRealisticBenefits()
    {
        $benefits = [
            "Competitive salary",
            "Health insurance",
            "Paid time off",
            "Professional development",
            "Flexible working hours",
            "Performance bonuses",
            "Retirement plan",
            "Transportation allowance",
            "Meal allowances",
            "Career advancement opportunities"
        ];

        return implode("\n", fake()->randomElements($benefits, fake()->numberBetween(3, 6)));
    }

    private function generateRelevantTags()
    {
        $tagSets = [
            ['php', 'laravel', 'javascript', 'mysql'],
            ['marketing', 'social-media', 'content-creation', 'analytics'],
            ['finance', 'accounting', 'excel', 'reporting'],
            ['project-management', 'agile', 'scrum', 'leadership'],
            ['data-analysis', 'sql', 'python', 'tableau'],
            ['sales', 'customer-service', 'negotiation', 'crm'],
            ['hr', 'recruitment', 'employee-relations', 'training'],
            ['design', 'photoshop', 'illustrator', 'creativity'],
            ['engineering', 'autocad', 'project-planning', 'technical'],
            ['healthcare', 'patient-care', 'medical-records', 'empathy']
        ];

        return fake()->randomElement($tagSets);
    }

}