<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\Job;
use Illuminate\Database\Seeder;

class CompaniesAndJobsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create 20 companies with realistic data
        Company::factory(20)->create();

        // Create 100 jobs with realistic data
        Job::factory(100)->create();

        // Create some verified jobs (simulate admin approval)
        Job::where('id', '<=', 20)->update([
            'verification_status' => 'verified',
            'verified_at' => now(),
        ]);

        // Create some featured jobs
        Job::where('verification_status', 'verified')
            ->inRandomOrder()
            ->limit(10)
            ->update(['featured' => true]);

        // Create some jobs with application deadlines
        Job::inRandomOrder()
            ->limit(30)
            ->update([
                'application_deadline' => now()->addDays(rand(7, 60)),
            ]);
    }
}