<?php
// HireCameroon Installation Script
// Run this once after deployment, then delete it

echo "<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>HireCameroon - Installation</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f0f0f0; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .success { color: #28a745; }
        .error { color: #dc3545; }
        .info { color: #007bff; }
        pre { background: #f8f8f8; padding: 15px; border-radius: 5px; overflow-x: auto; }
        .step { margin: 20px 0; padding: 15px; border-left: 4px solid #007bff; background: #f8f9fa; }
        .step.success { border-left-color: #28a745; }
        .step.error { border-left-color: #dc3545; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🚀 HireCameroon Installation</h1>
        <div id='output'></div>
    </div>

    <script>
        const output = document.getElementById('output');
        let stepCount = 0;

        function addStep(message, type = 'info') {
            stepCount++;
            const step = document.createElement('div');
            step.className = `step ${type}`;
            step.innerHTML = `<strong>Step ${stepCount}:</strong> ${message}`;
            output.appendChild(step);
            output.scrollTop = output.scrollHeight;
        }

        async function runInstallation() {
            try {
                addStep('Loading Laravel framework...', 'info');

                // Step 1: Load Laravel
                const loadResponse = await fetch('install-step.php?action=loadLaravel');
                const loadData = await loadResponse.json();

                if (loadData.success) {
                    addStep('Laravel framework loaded successfully', 'success');
                } else {
                    addStep('Failed to load Laravel: ' + loadData.message, 'error');
                    return;
                }

                // Step 2: Check database
                addStep('Checking database connection...', 'info');
                const dbResponse = await fetch('install-step.php?action=checkDatabase');
                const dbData = await dbResponse.json();

                if (dbData.success) {
                    addStep('Database connection successful', 'success');
                } else {
                    addStep('Database connection failed: ' + dbData.message, 'error');
                    return;
                }

                // Step 3: Run migrations
                addStep('Running database migrations...', 'info');
                const migrateResponse = await fetch('install-step.php?action=runMigrations');
                const migrateData = await migrateResponse.json();

                if (migrateData.success) {
                    addStep('Database migrations completed successfully', 'success');
                } else {
                    addStep('Migration failed: ' + migrateData.message, 'error');
                    if (migrateData.details) {
                        addStep('Details: ' + migrateData.details, 'error');
                    }
                    return;
                }

                // Step 4: Seed database
                addStep('Seeding database with initial data...', 'info');
                const seedResponse = await fetch('install-step.php?action=seedDatabase');
                const seedData = await seedResponse.json();

                if (seedData.success) {
                    addStep('Database seeded successfully', 'success');
                } else {
                    addStep('Seeding failed: ' + seedData.message, 'error');
                    if (seedData.details) {
                        addStep('Details: ' + seedData.details, 'error');
                    }
                    return;
                }

                // Step 5: Optimize application
                addStep('Optimizing application performance...', 'info');
                const optimizeResponse = await fetch('install-step.php?action=optimizeApp');
                const optimizeData = await optimizeResponse.json();

                if (optimizeData.success) {
                    addStep('Application optimized successfully', 'success');
                } else {
                    addStep('Optimization failed: ' + optimizeData.message, 'error');
                    return;
                }

                // Step 6: Finalize
                addStep('Finalizing installation...', 'info');
                const finalizeResponse = await fetch('install-step.php?action=finalize');
                const finalizeData = await finalizeResponse.json();

                if (finalizeData.success) {
                    addStep('Installation finalized successfully', 'success');
                } else {
                    addStep('Finalization failed: ' + finalizeData.message, 'error');
                    return;
                }

                // Success message
                addStep('🎉 Installation completed successfully!', 'success');
                setTimeout(() => {
                    output.innerHTML += `
                        <div style='margin-top: 30px; padding: 20px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 5px;'>
                            <h3 style='color: #155724; margin-top: 0;'>✅ Installation Complete!</h3>
                            <p style='margin-bottom: 15px;'><strong>Next steps:</strong></p>
                            <ol style='margin-bottom: 15px;'>
                                <li>Delete this <code>install.php</code> file for security</li>
                                <li>Visit your website: <a href='https://hirecameroon.com' target='_blank'>https://hirecameroon.com</a></li>
                                <li>Test admin login: <strong>admin@hirecameroon.com / admin123</strong></li>
                                <li>Configure email and payment settings in your .env file</li>
                            </ol>
                            <a href='https://hirecameroon.com' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>🚀 Visit Your Website</a>
                        </div>
                    `;
                }, 1000);

            } catch (error) {
                addStep('Installation failed with error: ' + error.message, 'error');
            }
        }

        // Start installation when page loads
        document.addEventListener('DOMContentLoaded', runInstallation);
    </script>
</body>
</html>";

try {
    // Load Laravel
    require_once 'vendor/autoload.php';
    $app = require_once 'bootstrap/app.php';
    $kernel = $app->make('Illuminate\Contracts\Console\Kernel');
    $kernel->bootstrap();

    echo "<script>addStep('✓ Laravel loaded successfully', 'success');</script>";

    // Check database connection
    try {
        $pdo = $app->make('db')->connection()->getPdo();
        echo "<script>addStep('✓ Database connection successful', 'success');</script>";
    } catch (Exception $e) {
        echo "<script>addStep('✗ Database connection failed: " . addslashes($e->getMessage()) . "', 'error');</script>";
        echo "<script>addStep('Please check your .env database configuration', 'error');</script>";
        exit;
    }

    // Run migrations
    echo "<script>addStep('Running database migrations...', 'info');</script>";
    $exitCode = $kernel->call('migrate', ['--force' => true]);
    if ($exitCode === 0) {
        echo "<script>addStep('✓ Migrations completed successfully', 'success');</script>";
    } else {
        echo "<script>addStep('✗ Migration failed', 'error');</script>";
        echo "<script>addStep('Details: " . addslashes($kernel->output()) . "', 'error');</script>";
        exit;
    }

    // Seed database
    echo "<script>addStep('Seeding database...', 'info');</script>";
    $exitCode = $kernel->call('db:seed', ['--force' => true]);
    if ($exitCode === 0) {
        echo "<script>addStep('✓ Database seeded successfully', 'success');</script>";
    } else {
        echo "<script>addStep('✗ Seeding failed', 'error');</script>";
        echo "<script>addStep('Details: " . addslashes($kernel->output()) . "', 'error');</script>";
    }

    // Clear and cache
    echo "<script>addStep('Optimizing application...', 'info');</script>";
    $kernel->call('config:cache');
    $kernel->call('route:cache');
    $kernel->call('view:cache');
    echo "<script>addStep('✓ Application optimized', 'success');</script>";

    // Generate key if needed
    if (empty(env('APP_KEY'))) {
        $kernel->call('key:generate');
        echo "<script>addStep('✓ Application key generated', 'success');</script>";
    }

    echo "<script>
        addStep('🎉 Installation completed successfully!', 'success');
        setTimeout(() => {
            document.querySelector('.container').innerHTML += `
                <div style='margin-top: 30px; padding: 20px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 5px;'>
                    <h3 style='color: #155724; margin-top: 0;'>✅ Installation Complete!</h3>
                    <p style='margin-bottom: 15px;'><strong>Next steps:</strong></p>
                    <ol style='margin-bottom: 15px;'>
                        <li>Delete this <code>install.php</code> file for security</li>
                        <li>Visit your website: <a href='https://hirecameroon.com' target='_blank'>https://hirecameroon.com</a></li>
                        <li>Test admin login: <strong>admin@hirecameroon.com / admin123</strong></li>
                        <li>Configure email and payment settings in your .env file</li>
                    </ol>
                    <a href='https://hirecameroon.com' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>🚀 Visit Your Website</a>
                </div>
            `;
        }, 1000);
    </script>";

} catch (Exception $e) {
    echo "<script>addStep('✗ Installation failed: " . addslashes($e->getMessage()) . "', 'error');</script>";
    echo "<script>addStep('Stack trace: " . addslashes(substr($e->getTraceAsString(), 0, 500)) . "...', 'error');</script>";
}
?>