<?php
// HireCameroon Requirements Checker
header('Content-Type: application/json');

$check = $_GET['check'] ?? '';

switch ($check) {
    case 'php':
        $version = PHP_VERSION;
        $pass = version_compare($version, '8.2.0', '>=');
        echo json_encode([
            'pass' => $pass,
            'version' => $version,
            'required' => '8.2.0+'
        ]);
        break;

    case 'composer':
        $pass = file_exists('../vendor/autoload.php');
        $status = $pass ? 'Installed' : 'Missing vendor/autoload.php';
        echo json_encode([
            'pass' => $pass,
            'status' => $status
        ]);
        break;

    case 'storage':
        $checks = [
            '../storage/' => is_writable('../storage/'),
            '../storage/app/' => is_writable('../storage/app/'),
            '../storage/framework/' => is_writable('../storage/framework/'),
            '../storage/logs/' => is_writable('../storage/logs/'),
            '../bootstrap/cache/' => is_writable('../bootstrap/cache/')
        ];

        $pass = !in_array(false, $checks, true);
        $status = $pass ? 'All writable' : 'Some directories not writable';

        echo json_encode([
            'pass' => $pass,
            'status' => $status,
            'details' => $checks
        ]);
        break;

    case 'database':
        try {
            if (!file_exists('../.env')) {
                echo json_encode([
                    'pass' => false,
                    'status' => 'Missing .env file'
                ]);
                break;
            }

            // Load environment
            $env = parse_ini_file('../.env');
            if (!$env) {
                echo json_encode([
                    'pass' => false,
                    'status' => 'Cannot parse .env file'
                ]);
                break;
            }

            // Try database connection
            $dsn = "mysql:host={$env['DB_HOST']};port={$env['DB_PORT']};dbname={$env['DB_DATABASE']}";
            $pdo = new PDO($dsn, $env['DB_USERNAME'], $env['DB_PASSWORD']);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            echo json_encode([
                'pass' => true,
                'status' => 'Connected successfully'
            ]);

        } catch (Exception $e) {
            echo json_encode([
                'pass' => false,
                'status' => 'Connection failed: ' . $e->getMessage()
            ]);
        }
        break;

    case 'env':
        $pass = file_exists('.env');
        $status = $pass ? 'Present' : 'Missing .env file';
        echo json_encode([
            'pass' => $pass,
            'status' => $status
        ]);
        break;

    default:
        echo json_encode([
            'error' => 'Unknown check type'
        ]);
}
?>