<?php
// HireCameroon Installation Step Processor
header('Content-Type: application/json');

if (!isset($_GET['action'])) {
    echo json_encode(['success' => false, 'message' => 'No action specified']);
    exit;
}

$action = $_GET['action'];

try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make('Illuminate\Contracts\Console\Kernel');
    $kernel->bootstrap();

    switch ($action) {
        case 'loadLaravel':
            // Laravel is already loaded above
            echo json_encode(['success' => true, 'message' => 'Laravel framework loaded successfully']);
            break;

        case 'checkDatabase':
            $app->make('db')->connection()->getPdo();
            echo json_encode(['success' => true, 'message' => 'Database connection verified']);
            break;

        case 'runMigrations':
            $exitCode = $kernel->call('migrate', ['--force' => true]);
            if ($exitCode === 0) {
                echo json_encode(['success' => true, 'message' => 'Database migrations completed successfully']);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Database migration failed',
                    'details' => $kernel->output()
                ]);
            }
            break;

        case 'seedDatabase':
            $exitCode = $kernel->call('db:seed', ['--force' => true]);
            if ($exitCode === 0) {
                echo json_encode(['success' => true, 'message' => 'Database seeded with initial data']);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Database seeding failed',
                    'details' => $kernel->output()
                ]);
            }
            break;

        case 'optimizeApp':
            $kernel->call('config:cache');
            $kernel->call('route:cache');
            $kernel->call('view:cache');
            echo json_encode(['success' => true, 'message' => 'Application configuration optimized']);
            break;

        case 'finalize':
            // Generate app key if missing
            if (empty(env('APP_KEY'))) {
                $kernel->call('key:generate');
            }

            // Set proper permissions (attempt)
            $dirs = ['storage', 'bootstrap/cache'];
            foreach ($dirs as $dir) {
                if (is_dir($dir)) {
                    chmod($dir, 0755);
                }
            }

            echo json_encode(['success' => true, 'message' => 'Installation finalized successfully']);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Unknown installation action']);
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Installation step failed: ' . $e->getMessage(),
        'details' => $e->getTraceAsString()
    ]);
}
?>