<?php
// HireCameroon Configuration Saver
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$input = file_get_contents('php://input');
$config = json_decode($input, true);

if (!$config) {
    echo json_encode(['success' => false, 'message' => 'Invalid JSON data']);
    exit;
}

try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    // Build .env content
    $envContent = "# HireCameroon Production Environment\n";
    $envContent .= "# Generated by Installation Wizard\n\n";

    $envContent .= "APP_NAME=\"{$config['app_name']}\"\n";
    $envContent .= "APP_ENV=production\n";
    $envContent .= "APP_KEY=base64:2l5O/Ynk4vtC+2ncXPDwHAaxqms7F2Lk0RTA1MuK1kE=\n";
    $envContent .= "APP_DEBUG=false\n";
    $envContent .= "APP_URL=\"{$config['app_url']}\"\n\n";

    $envContent .= "DB_CONNECTION=mysql\n";
    $envContent .= "DB_HOST=\"{$config['db_host']}\"\n";
    $envContent .= "DB_PORT=\"{$config['db_port']}\"\n";
    $envContent .= "DB_DATABASE=\"{$config['db_name']}\"\n";
    $envContent .= "DB_USERNAME=\"{$config['db_user']}\"\n";
    $envContent .= "DB_PASSWORD=\"{$config['db_pass']}\"\n\n";

    $envContent .= "MAIL_MAILER=\"{$config['mail_driver']}\"\n";
    $envContent .= "MAIL_HOST=\"{$config['mail_host']}\"\n";
    $envContent .= "MAIL_PORT=\"{$config['mail_port']}\"\n";
    $envContent .= "MAIL_USERNAME=\"{$config['mail_username']}\"\n";
    $envContent .= "MAIL_PASSWORD=\"{$config['mail_password']}\"\n";
    $envContent .= "MAIL_ENCRYPTION=\"{$config['mail_encryption']}\"\n";
    $envContent .= "MAIL_FROM_ADDRESS=\"{$config['mail_from_address']}\"\n";
    $envContent .= "MAIL_FROM_NAME=\"{$config['mail_from_name']}\"\n\n";

    if (!empty($config['mesomb_app_key'])) {
        $envContent .= "# Mesomb Payment Configuration\n";
        $envContent .= "MESOMB_APPLICATION_KEY=\"{$config['mesomb_app_key']}\"\n";
        $envContent .= "MESOMB_ACCESS_KEY=\"{$config['mesomb_access_key']}\"\n";
        $envContent .= "MESOMB_SECRET_KEY=\"{$config['mesomb_secret_key']}\"\n\n";
    }

    $envContent .= "# File Upload Configuration\n";
    $envContent .= "FILESYSTEM_DISK=public\n";
    $envContent .= "MAX_FILE_SIZE=10240\n";
    $envContent .= "ALLOWED_FILE_TYPES=pdf,doc,docx,jpg,jpeg,png\n\n";

    $envContent .= "# Application Settings\n";
    $envContent .= "DEFAULT_CURRENCY=\"{$config['currency']}\"\n";
    $envContent .= "DEFAULT_LANGUAGE=en\n";
    $envContent .= "TIMEZONE=\"{$config['timezone']}\"\n\n";

    $envContent .= "# Admin Configuration\n";
    $envContent .= "ADMIN_EMAIL=\"{$config['admin_email']}\"\n";
    $envContent .= "ADMIN_PASSWORD=\"{$config['admin_password']}\"\n";

    // Write .env file
    $result = file_put_contents('../.env', $envContent);

    if ($result === false) {
        echo json_encode(['success' => false, 'message' => 'Failed to write .env file']);
        exit;
    }

    // Test database connection with new config
    try {
        $dsn = "mysql:host={$config['db_host']};port={$config['db_port']};dbname={$config['db_name']}";
        $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        echo json_encode([
            'success' => true,
            'message' => 'Configuration saved successfully and database connection verified'
        ]);

    } catch (PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Configuration saved but database connection failed: ' . $e->getMessage()
        ]);
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to save configuration: ' . $e->getMessage()
    ]);
}
?>