// Form step handling
let currentStep = 1;
const totalSteps = 3;

function handleAccountTypeChange() {
    const personalRadio = document.getElementById('account_type_personal');
    const companyRadio = document.getElementById('account_type_company');
    const personalFields = document.getElementById('personalFields');
    const companyFields = document.getElementById('companyFields');
    const nameInput = document.getElementById('name');
    const companyNameInput = document.getElementById('company_name');

    if (personalRadio && companyRadio && personalFields && companyFields) {
        if (personalRadio.checked) {
            personalFields.classList.remove('hidden');
            companyFields.classList.add('hidden');
            if (nameInput) {
                nameInput.setAttribute('required', 'required');
                nameInput.placeholder = 'Enter your full name';
            }
            if (companyNameInput) {
                companyNameInput.removeAttribute('required');
            }
        } else if (companyRadio.checked) {
            companyFields.classList.remove('hidden');
            personalFields.classList.add('hidden');
            if (nameInput) {
                nameInput.removeAttribute('required');
                nameInput.placeholder = 'Your full name (company representative)';
            }
            if (companyNameInput) {
                companyNameInput.setAttribute('required', 'required');
            }
        }
        validateStep(currentStep);
    }
}

function validateStep(step) {
    let isValid = true;
    const errors = [];
    
    switch(step) {
        case 1:
            isValid = document.querySelector('input[name="account_type"]:checked') !== null;
            if (!isValid) errors.push('Please select an account type');
            break;
            
        case 2:
            const requiredFields = ['email', 'password', 'password_confirmation'];
            requiredFields.forEach(field => {
                const input = document.getElementById(field);
                if (input && !input.value.trim()) {
                    isValid = false;
                    input.classList.add('border-red-500', 'bg-red-50/50');
                    errors.push(`${field.replace('_', ' ')} is required`);
                } else if (input) {
                    input.classList.remove('border-red-500', 'bg-red-50/50');
                }
            });
            
            // Password validation
            const password = document.getElementById('password');
            const confirmation = document.getElementById('password_confirmation');
            if (password && confirmation && password.value !== confirmation.value) {
                isValid = false;
                errors.push('Passwords do not match');
                password.classList.add('border-red-500', 'bg-red-50/50');
                confirmation.classList.add('border-red-500', 'bg-red-50/50');
            }
            break;
            
        case 3:
            const accountType = document.querySelector('input[name="account_type"]:checked').value;
            if (accountType === 'company') {
                const companyFields = ['company_name', 'position', 'company_sector', 'company_size'];
                companyFields.forEach(field => {
                    const input = document.getElementById(field);
                    if (input && !input.value.trim()) {
                        isValid = false;
                        input.classList.add('border-red-500', 'bg-red-50/50');
                        errors.push(`${field.replace('_', ' ')} is required`);
                    } else if (input) {
                        input.classList.remove('border-red-500', 'bg-red-50/50');
                    }
                });
            } else {
                const personalFields = ['name'];
                personalFields.forEach(field => {
                    const input = document.getElementById(field);
                    if (input && !input.value.trim()) {
                        isValid = false;
                        input.classList.add('border-red-500', 'bg-red-50/50');
                        errors.push(`${field} is required`);
                    } else if (input) {
                        input.classList.remove('border-red-500', 'bg-red-50/50');
                    }
                });
            }
            break;
    }
    
    if (!isValid && errors.length > 0) {
        showError(errors.join('<br>'));
    }
    
    return isValid;
}

function nextStep() {
    if (!validateStep(currentStep)) {
        return;
    }
    
    if (currentStep < totalSteps) {
        // Hide current step
        document.getElementById(`step${currentStep}`).classList.add('opacity-0');
        setTimeout(() => {
            document.getElementById(`step${currentStep}`).classList.add('hidden');
            currentStep++;
            // Show next step
            const nextStepEl = document.getElementById(`step${currentStep}`);
            nextStepEl.classList.remove('hidden');
            setTimeout(() => {
                nextStepEl.classList.remove('opacity-0');
            }, 50);
            updateProgress();
        }, 300);
    }
}

function prevStep() {
    if (currentStep > 1) {
        // Hide current step
        document.getElementById(`step${currentStep}`).classList.add('opacity-0');
        setTimeout(() => {
            document.getElementById(`step${currentStep}`).classList.add('hidden');
            currentStep--;
            // Show previous step
            const prevStepEl = document.getElementById(`step${currentStep}`);
            prevStepEl.classList.remove('hidden');
            setTimeout(() => {
                prevStepEl.classList.remove('opacity-0');
            }, 50);
            updateProgress();
        }, 300);
    }
}

function updateProgress() {
    document.getElementById('currentStep').textContent = currentStep;
    
    // Update progress indicators
    document.querySelectorAll('.step-indicator').forEach((indicator, index) => {
        if (index + 1 < currentStep) {
            indicator.classList.remove('bg-gray-200', 'text-gray-600');
            indicator.classList.add('bg-green-500', 'text-white');
        } else if (index + 1 === currentStep) {
            indicator.classList.remove('bg-gray-200', 'text-gray-600', 'bg-green-500');
            indicator.classList.add('bg-yellow-500', 'text-white');
        } else {
            indicator.classList.remove('bg-yellow-500', 'bg-green-500', 'text-white');
            indicator.classList.add('bg-gray-200', 'text-gray-600');
        }
    });

    // Update progress lines
    document.querySelectorAll('.step-line').forEach((line, index) => {
        if (index + 1 < currentStep) {
            line.classList.remove('bg-gray-200');
            line.classList.add('bg-green-500');
        } else {
            line.classList.remove('bg-green-500');
            line.classList.add('bg-gray-200');
        }
    });
}

function showError(message) {
    const existingError = document.querySelector('.error-toast');
    if (existingError) {
        existingError.remove();
    }

    const errorDiv = document.createElement('div');
    errorDiv.className = 'error-toast fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg transform transition-all duration-500 ease-in-out translate-x-full z-50';
    errorDiv.innerHTML = message;
    document.body.appendChild(errorDiv);
    
    setTimeout(() => {
        errorDiv.classList.remove('translate-x-full');
    }, 100);
    
    setTimeout(() => {
        errorDiv.classList.add('translate-x-full');
        setTimeout(() => {
            errorDiv.remove();
        }, 500);
    }, 5000);
}

function previewImage(input, previewId) {
    const preview = document.getElementById(previewId);
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.classList.remove('hidden');
            // Hide the default icon
            const icon = preview.parentElement.querySelector('svg');
            if (icon) icon.style.display = 'none';
        };
        reader.readAsDataURL(input.files[0]);
    }
}

// Form submission validation
document.getElementById('registrationForm').addEventListener('submit', function(e) {
    if (!validateStep(currentStep)) {
        e.preventDefault();
        return;
    }
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    handleAccountTypeChange();
    updateProgress();
    
    // Add animation classes to steps
    document.querySelectorAll('[id^="step"]').forEach(step => {
        if (!step.classList.contains('hidden')) {
            step.classList.add('transition-all', 'duration-300', 'ease-in-out');
        }
    });
});