@extends('admin.dashboard')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <h1 class="h3 mb-4">Communication Management</h1>
            
            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="card-title">Emails Sent</h5>
                                    <h2 class="mb-0">{{ number_format($stats['emails_sent'] ?? 0) }}</h2>
                                </div>
                                <div class="text-end">
                                    <i class="fas fa-envelope fa-2x opacity-75"></i>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer bg-primary border-0">
                            <small>Last 7 days</small>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="card-title">SMS Sent</h5>
                                    <h2 class="mb-0">{{ number_format($stats['sms_sent'] ?? 0) }}</h2>
                                </div>
                                <div class="text-end">
                                    <i class="fas fa-sms fa-2x opacity-75"></i>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer bg-success border-0">
                            <small>Last 7 days</small>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="card-title">Failed Emails</h5>
                                    <h2 class="mb-0">{{ number_format($stats['failed_emails'] ?? 0) }}</h2>
                                </div>
                                <div class="text-end">
                                    <i class="fas fa-exclamation-triangle fa-2x opacity-75"></i>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer bg-warning border-0">
                            <small>Last 7 days</small>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card bg-danger text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="card-title">Failed SMS</h5>
                                    <h2 class="mb-0">{{ number_format($stats['failed_sms'] ?? 0) }}</h2>
                                </div>
                                <div class="text-end">
                                    <i class="fas fa-times fa-2x opacity-75"></i>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer bg-danger border-0">
                            <small>Last 7 days</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Provider Status -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-envelope me-2"></i>Email Providers Status
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @foreach($providerStatus['email'] as $provider => $status)
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold text-capitalize">{{ ucfirst($provider) }}</span>
                                        <span class="badge {{ $status['success'] ? 'bg-success' : 'bg-danger' }}">
                                            {{ $status['success'] ? 'Connected' : 'Failed' }}
                                        </span>
                                    </div>
                                    <small class="text-muted">
                                        Response: {{ $status['response_time'] ?? 0 }}ms
                                    </small>
                                    @if(!$status['success'])
                                        <br><small class="text-danger">{{ $status['message'] }}</small>
                                    @endif
                                    <div class="mt-2">
                                        <button class="btn btn-sm btn-outline-primary" 
                                                onclick="testProvider('email', '{{ $provider }}')">
                                            Test Connection
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-sms me-2"></i>SMS Providers Status
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @foreach($providerStatus['sms'] as $provider => $status)
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold text-capitalize">{{ ucfirst($provider) }}</span>
                                        <span class="badge {{ $status['success'] ? 'bg-success' : 'bg-danger' }}">
                                            {{ $status['success'] ? 'Connected' : 'Failed' }}
                                        </span>
                                    </div>
                                    <small class="text-muted">
                                        Response: {{ $status['response_time'] ?? 0 }}ms
                                    </small>
                                    @if(!$status['success'])
                                        <br><small class="text-danger">{{ $status['message'] }}</small>
                                    @endif
                                    <div class="mt-2">
                                        <button class="btn btn-sm btn-outline-primary" 
                                                onclick="testProvider('sms', '{{ $provider }}')">
                                            Test Connection
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Quick Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-2">
                                    <a href="{{ route('admin.communication.settings') }}" class="btn btn-primary w-100">
                                        <i class="fas fa-cog me-2"></i>Settings
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <a href="{{ route('admin.communication.logs') }}" class="btn btn-info w-100">
                                        <i class="fas fa-history me-2"></i>View Logs
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <a href="{{ route('admin.communication.analytics') }}" class="btn btn-success w-100">
                                        <i class="fas fa-chart-line me-2"></i>Analytics
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <button class="btn btn-warning w-100" onclick="showTestModal()">
                                        <i class="fas fa-paper-plane me-2"></i>Send Test
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Recent Activity -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-clock me-2"></i>Recent Communication Activity
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Time</th>
                                            <th>Channel</th>
                                            <th>Provider</th>
                                            <th>Recipient</th>
                                            <th>Template</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($recentLogs as $log)
                                        <tr>
                                            <td>{{ $log->sent_at->format('M j, g:i A') }}</td>
                                            <td>
                                                <span class="badge {{ $log->channel === 'email' ? 'bg-primary' : 'bg-success' }}">
                                                    {{ ucfirst($log->channel) }}
                                                </span>
                                            </td>
                                            <td class="text-capitalize">{{ $log->provider }}</td>
                                            <td>{{ $log->recipient }}</td>
                                            <td>{{ $log->template ?: 'N/A' }}</td>
                                            <td>
                                                <span class="badge {{ $log->status === 'sent' ? 'bg-success' : 'bg-danger' }}">
                                                    {{ ucfirst($log->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                No communication activity yet
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Test Message Modal -->
<div class="modal fade" id="testMessageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Test Message</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="testMessageForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="testType" class="form-label">Channel</label>
                        <select class="form-select" id="testType" name="type" required>
                            <option value="">Select Channel</option>
                            <option value="email">Email</option>
                            <option value="sms">SMS</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="testProvider" class="form-label">Provider</label>
                        <select class="form-select" id="testProvider" name="provider" required>
                            <option value="">Select Provider</option>
                            <optgroup label="Email Providers">
                                <option value="smtp">SMTP</option>
                                <option value="phpmailer">PHP Mailer</option>
                                <option value="mailgun">Mailgun</option>
                                <option value="ses">AWS SES</option>
                                <option value="postmark">Postmark</option>
                            </optgroup>
                            <optgroup label="SMS Providers">
                                <option value="twilio">Twilio</option>
                                <option value="messagebird">MessageBird</option>
                                <option value="nexmo">Nexmo</option>
                                <option value="africatalking">Africa Talking</option>
                            </optgroup>
                        </select>
                    </div>
                    
                    <div class="mb-3" id="emailField">
                        <label for="testRecipient" class="form-label">Recipient Email</label>
                        <input type="email" class="form-control" id="testRecipient" name="recipient" required>
                    </div>
                    
                    <div class="mb-3 d-none" id="phoneField">
                        <label for="testPhone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" id="testPhone" name="phone" placeholder="+237612345678">
                        <div class="form-text">Include country code (e.g., +237 for Cameroon)</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Send Test</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
function testProvider(type, provider) {
    const url = type === 'email' ? 
        "{{ route('admin.communication.test.email') }}" :
        "{{ route('admin.communication.test.sms') }}";
    
    const formData = new FormData();
    formData.append('provider', provider);
    formData.append('_token', '{{ csrf_token() }}');
    
    fetch(url, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Connection test successful!');
            location.reload();
        } else {
            alert('Connection test failed: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error.message);
    });
}

function showTestModal() {
    const modal = new bootstrap.Modal(document.getElementById('testMessageModal'));
    modal.show();
}

document.getElementById('testType').addEventListener('change', function() {
    const emailField = document.getElementById('emailField');
    const phoneField = document.getElementById('phoneField');
    
    if (this.value === 'email') {
        emailField.classList.remove('d-none');
        phoneField.classList.add('d-none');
        document.getElementById('testPhone').value = '';
    } else if (this.value === 'sms') {
        emailField.classList.add('d-none');
        phoneField.classList.remove('d-none');
        document.getElementById('testRecipient').value = '';
    }
});

document.getElementById('testMessageForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    
    submitBtn.disabled = true;
    submitBtn.textContent = 'Sending...';
    
    fetch("{{ route('admin.communication.test.message') }}", {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Test message sent successfully!');
            bootstrap.Modal.getInstance(document.getElementById('testMessageModal')).hide();
        } else {
            alert('Failed to send test message: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error.message);
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.textContent = 'Send Test';
    });
});
</script>
@endpush