<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Content Moderation
            </h2>
            <div class="flex items-center space-x-4">
                <span class="px-3 py-1 bg-orange-100 text-orange-800 rounded-full text-sm font-medium">
                    Moderation Queue
                </span>
            </div>
        </div>
    </x-slot>

    <!-- Moderation Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Pending Review</p>
                    <p class="text-3xl font-black text-black">{{ $stats['pending_reviews'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Approved Today</p>
                    <p class="text-3xl font-black text-black">{{ $stats['approved_today'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Rejected Today</p>
                    <p class="text-3xl font-black text-black">{{ $stats['rejected_today'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Avg. Review Time</p>
                    <p class="text-3xl font-black text-black">{{ $stats['avg_review_time'] ?? '0m' }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Type Tabs -->
    <div class="mb-6">
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="border-b border-gray-100">
                <nav class="flex">
                    <button onclick="switchTab('jobs')" id="jobs-tab" class="tab-button active px-6 py-4 text-sm font-medium border-b-2 border-blue-500 text-blue-600">
                        Job Posts
                    </button>
                    <button onclick="switchTab('companies')" id="companies-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                        Companies
                    </button>
                    <button onclick="switchTab('reviews')" id="reviews-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                        Reviews
                    </button>
                    <button onclick="switchTab('applications')" id="applications-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                        Applications
                    </button>
                </nav>
            </div>

            <!-- Jobs Moderation -->
            <div id="jobs-content" class="tab-content p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-black">Job Posts Awaiting Review</h3>
                    <div class="flex items-center space-x-2">
                        <select id="jobStatusFilter" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="pending">Pending Review</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                </div>
                <div id="jobs-list" class="space-y-4">
                    <!-- Jobs will be loaded here -->
                </div>
            </div>

            <!-- Companies Moderation -->
            <div id="companies-content" class="tab-content p-6 hidden">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-black">Company Profiles Awaiting Review</h3>
                    <div class="flex items-center space-x-2">
                        <select id="companyStatusFilter" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="pending">Pending Review</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                </div>
                <div id="companies-list" class="space-y-4">
                    <!-- Companies will be loaded here -->
                </div>
            </div>

            <!-- Reviews Moderation -->
            <div id="reviews-content" class="tab-content p-6 hidden">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-black">Reviews Awaiting Moderation</h3>
                    <div class="flex items-center space-x-2">
                        <select id="reviewStatusFilter" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="pending">Pending Review</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                </div>
                <div id="reviews-list" class="space-y-4">
                    <!-- Reviews will be loaded here -->
                </div>
            </div>

            <!-- Applications Moderation -->
            <div id="applications-content" class="tab-content p-6 hidden">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-black">Applications Awaiting Review</h3>
                    <div class="flex items-center space-x-2">
                        <select id="applicationStatusFilter" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="pending">Pending Review</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                </div>
                <div id="applications-list" class="space-y-4">
                    <!-- Applications will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <!-- Moderation Actions Modal -->
    <div id="moderationModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-900" id="modalTitle">Review Content</h3>
                    <button onclick="closeModerationModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div id="modalContent" class="space-y-4">
                    <!-- Content will be loaded here -->
                </div>

                <div class="flex items-center justify-end space-x-4 mt-6">
                    <button onclick="closeModerationModal()" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">Cancel</button>
                    <button onclick="rejectContent()" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Reject</button>
                    <button onclick="approveContent()" class="px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">Approve</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        let currentTab = 'jobs';
        let currentContentId = null;
        let currentContentType = null;

        document.addEventListener('DOMContentLoaded', function() {
            loadContent('jobs');

            // Tab switching
            document.querySelectorAll('.tab-button').forEach(button => {
                button.addEventListener('click', function() {
                    const tabName = this.id.replace('-tab', '');
                    switchTab(tabName);
                });
            });

            // Filter changes
            document.getElementById('jobStatusFilter').addEventListener('change', () => loadContent('jobs'));
            document.getElementById('companyStatusFilter').addEventListener('change', () => loadContent('companies'));
            document.getElementById('reviewStatusFilter').addEventListener('change', () => loadContent('reviews'));
            document.getElementById('applicationStatusFilter').addEventListener('change', () => loadContent('applications'));
        });

        function switchTab(tabName) {
            // Update tab buttons
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active', 'border-b-2', 'border-blue-500', 'text-blue-600');
                button.classList.add('text-gray-500');
            });

            document.getElementById(tabName + '-tab').classList.add('active', 'border-b-2', 'border-blue-500', 'text-blue-600');

            // Update content visibility
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });

            document.getElementById(tabName + '-content').classList.remove('hidden');

            currentTab = tabName;
            loadContent(tabName);
        }

        function loadContent(type) {
            const status = document.getElementById(type + 'StatusFilter').value;
            const params = new URLSearchParams({
                type: type,
                status: status
            });

            fetch(`/admin/content-moderation/data?${params}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                renderContent(type, data.content);
            })
            .catch(error => {
                console.error('Error loading content:', error);
            });
        }

        function renderContent(type, content) {
            const container = document.getElementById(type + '-list');
            container.innerHTML = '';

            if (content.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <p class="text-gray-500">No content found</p>
                    </div>
                `;
                return;
            }

            content.forEach(item => {
                const card = createContentCard(type, item);
                container.appendChild(card);
            });
        }

        function createContentCard(type, item) {
            const card = document.createElement('div');
            card.className = 'bg-gray-50 rounded-xl p-6 border border-gray-200';

            let content = '';

            switch (type) {
                case 'jobs':
                    content = `
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center mb-2">
                                    <h4 class="text-lg font-bold text-black">${item.title}</h4>
                                    <span class="ml-2 px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Pending Review</span>
                                </div>
                                <p class="text-gray-600 mb-2">${item.company ? item.company.name : 'Unknown Company'}</p>
                                <p class="text-sm text-gray-500 mb-4">${item.description ? item.description.substring(0, 200) + '...' : 'No description'}</p>
                                <div class="flex items-center text-sm text-gray-500">
                                    <span class="mr-4">Posted ${new Date(item.created_at).toLocaleDateString()}</span>
                                    <span>Salary: ${item.salary_range || 'Not specified'}</span>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2 ml-4">
                                <button onclick="reviewContent('job', ${item.id})" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">Review</button>
                            </div>
                        </div>
                    `;
                    break;

                case 'companies':
                    content = `
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center mb-2">
                                    <h4 class="text-lg font-bold text-black">${item.name}</h4>
                                    <span class="ml-2 px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Pending Review</span>
                                </div>
                                <p class="text-gray-600 mb-2">${item.description ? item.description.substring(0, 200) + '...' : 'No description'}</p>
                                <div class="flex items-center text-sm text-gray-500">
                                    <span class="mr-4">Created ${new Date(item.created_at).toLocaleDateString()}</span>
                                    <span>Industry: ${item.industry || 'Not specified'}</span>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2 ml-4">
                                <button onclick="reviewContent('company', ${item.id})" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">Review</button>
                            </div>
                        </div>
                    `;
                    break;

                case 'reviews':
                    content = `
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center mb-2">
                                    <h4 class="text-lg font-bold text-black">Review for ${item.company ? item.company.name : 'Unknown Company'}</h4>
                                    <span class="ml-2 px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Pending Review</span>
                                </div>
                                <div class="flex items-center mb-2">
                                    ${createStarRating(item.rating || 0)}
                                </div>
                                <p class="text-gray-600 mb-2">${item.content ? item.content.substring(0, 200) + '...' : 'No content'}</p>
                                <div class="flex items-center text-sm text-gray-500">
                                    <span>By ${item.user ? item.user.name : 'Unknown User'}</span>
                                    <span class="mx-2">•</span>
                                    <span>${new Date(item.created_at).toLocaleDateString()}</span>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2 ml-4">
                                <button onclick="reviewContent('review', ${item.id})" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">Review</button>
                            </div>
                        </div>
                    `;
                    break;

                case 'applications':
                    content = `
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center mb-2">
                                    <h4 class="text-lg font-bold text-black">Application for ${item.job ? item.job.title : 'Unknown Job'}</h4>
                                    <span class="ml-2 px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Pending Review</span>
                                </div>
                                <p class="text-gray-600 mb-2">By ${item.user ? item.user.name : 'Unknown User'}</p>
                                <p class="text-sm text-gray-500 mb-4">${item.cover_letter ? item.cover_letter.substring(0, 200) + '...' : 'No cover letter'}</p>
                                <div class="flex items-center text-sm text-gray-500">
                                    <span>Applied ${new Date(item.created_at).toLocaleDateString()}</span>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2 ml-4">
                                <button onclick="reviewContent('application', ${item.id})" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">Review</button>
                            </div>
                        </div>
                    `;
                    break;
            }

            card.innerHTML = content;
            return card;
        }

        function createStarRating(rating) {
            let stars = '';
            for (let i = 1; i <= 5; i++) {
                stars += `<svg class="w-4 h-4 ${i <= rating ? 'text-yellow-400' : 'text-gray-300'}" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                </svg>`;
            }
            return stars;
        }

        function reviewContent(type, id) {
            currentContentType = type;
            currentContentId = id;

            fetch(`/admin/content-moderation/${type}/${id}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                showModerationModal(data.content);
            })
            .catch(error => {
                console.error('Error loading content details:', error);
            });
        }

        function showModerationModal(content) {
            const modal = document.getElementById('moderationModal');
            const title = document.getElementById('modalTitle');
            const contentDiv = document.getElementById('modalContent');

            title.textContent = `Review ${currentContentType.charAt(0).toUpperCase() + currentContentType.slice(1)}`;

            let details = '';
            switch (currentContentType) {
                case 'job':
                    details = `
                        <div class="space-y-4">
                            <div>
                                <h4 class="font-semibold text-gray-900">Job Title</h4>
                                <p class="text-gray-700">${content.title}</p>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Company</h4>
                                <p class="text-gray-700">${content.company ? content.company.name : 'Unknown'}</p>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Description</h4>
                                <div class="text-gray-700 max-h-40 overflow-y-auto">${content.description || 'No description'}</div>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Requirements</h4>
                                <div class="text-gray-700 max-h-40 overflow-y-auto">${content.requirements || 'No requirements specified'}</div>
                            </div>
                        </div>
                    `;
                    break;

                case 'company':
                    details = `
                        <div class="space-y-4">
                            <div>
                                <h4 class="font-semibold text-gray-900">Company Name</h4>
                                <p class="text-gray-700">${content.name}</p>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Description</h4>
                                <div class="text-gray-700 max-h-40 overflow-y-auto">${content.description || 'No description'}</div>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Website</h4>
                                <p class="text-gray-700">${content.website || 'Not provided'}</p>
                            </div>
                        </div>
                    `;
                    break;

                case 'review':
                    details = `
                        <div class="space-y-4">
                            <div>
                                <h4 class="font-semibold text-gray-900">Rating</h4>
                                <div class="flex items-center">
                                    ${createStarRating(content.rating || 0)}
                                    <span class="ml-2 text-gray-700">${content.rating || 0}/5</span>
                                </div>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Review Content</h4>
                                <div class="text-gray-700 max-h-40 overflow-y-auto">${content.content || 'No content'}</div>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Company</h4>
                                <p class="text-gray-700">${content.company ? content.company.name : 'Unknown'}</p>
                            </div>
                        </div>
                    `;
                    break;

                case 'application':
                    details = `
                        <div class="space-y-4">
                            <div>
                                <h4 class="font-semibold text-gray-900">Job Position</h4>
                                <p class="text-gray-700">${content.job ? content.job.title : 'Unknown'}</p>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Applicant</h4>
                                <p class="text-gray-700">${content.user ? content.user.name : 'Unknown'}</p>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-900">Cover Letter</h4>
                                <div class="text-gray-700 max-h-40 overflow-y-auto">${content.cover_letter || 'No cover letter'}</div>
                            </div>
                        </div>
                    `;
                    break;
            }

            contentDiv.innerHTML = details;
            modal.classList.remove('hidden');
        }

        function closeModerationModal() {
            document.getElementById('moderationModal').classList.add('hidden');
            currentContentId = null;
            currentContentType = null;
        }

        function approveContent() {
            moderateContent('approve');
        }

        function rejectContent() {
            moderateContent('reject');
        }

        function moderateContent(action) {
            fetch(`/admin/content-moderation/${currentContentType}/${currentContentId}/${action}`, {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeModerationModal();
                    loadContent(currentTab);
                    showSuccess(`${currentContentType.charAt(0).toUpperCase() + currentContentType.slice(1)} ${action}d successfully`);
                } else {
                    showError(data.message || `Failed to ${action} content`);
                }
            })
            .catch(error => {
                console.error('Error moderating content:', error);
                showError(`Failed to ${action} content`);
            });
        }

        function showSuccess(message) {
            // Simple success notification
            alert(message);
        }

        function showError(message) {
            // Simple error notification
            alert(message);
        }
    </script>
</x-layouts.app>