<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                SEO Management
            </h2>
            <div class="flex items-center space-x-4">
                <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm font-medium">
                    Search Optimization
                </span>
            </div>
        </div>
    </x-slot>

    <!-- SEO Overview Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Organic Traffic</p>
                    <p class="text-3xl font-black text-black">{{ number_format($seoStats['organic_traffic'] ?? 0) }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">+15%</span>
                <span class="text-gray-500 ml-2">vs last month</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Keyword Rankings</p>
                    <p class="text-3xl font-black text-black">{{ $seoStats['keyword_rankings'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">+8</span>
                <span class="text-gray-500 ml-2">new rankings</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Backlinks</p>
                    <p class="text-3xl font-black text-black">{{ number_format($seoStats['backlinks'] ?? 0) }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">+23</span>
                <span class="text-gray-500 ml-2">this month</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Page Speed Score</p>
                    <p class="text-3xl font-black text-black">{{ $seoStats['page_speed'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">+5</span>
                <span class="text-gray-500 ml-2">points improved</span>
            </div>
        </div>
    </div>

    <!-- SEO Management Tabs -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 mb-8">
        <div class="border-b border-gray-100">
            <nav class="flex">
                <button onclick="switchSEOTab('meta')" id="meta-tab" class="tab-button active px-6 py-4 text-sm font-medium border-b-2 border-blue-500 text-blue-600">
                    Meta Tags & Content
                </button>
                <button onclick="switchSEOTab('keywords')" id="keywords-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Keywords
                </button>
                <button onclick="switchSEOTab('sitemap')" id="sitemap-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Sitemap & Structure
                </button>
                <button onclick="switchSEOTab('analytics')" id="analytics-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Analytics
                </button>
            </nav>
        </div>

        <!-- Meta Tags & Content Tab -->
        <div id="meta-content" class="tab-content p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Page Meta Tags</h3>
                <button onclick="openMetaEditorModal()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                    Edit Meta Tags
                </button>
            </div>

            <div class="space-y-6">
                <!-- Homepage Meta -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h4 class="text-lg font-semibold text-black">Homepage</h4>
                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-medium">Optimized</span>
                    </div>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Title Tag</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['home']['title'] ?? 'HireCameroon - Find Work and Hire Faster in Cameroon' }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Meta Description</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['home']['description'] ?? 'Find work and hire faster in Cameroon with HireCameroon - bilingual jobs, ATS, and mobile payments.' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Jobs Page Meta -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h4 class="text-lg font-semibold text-black">Jobs Page</h4>
                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Needs Review</span>
                    </div>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Title Tag</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['jobs']['title'] ?? 'Job Opportunities in Cameroon - HireCameroon' }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Meta Description</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['jobs']['description'] ?? 'Browse thousands of job opportunities in Cameroon. Find your next career move with HireCameroon.' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Companies Page Meta -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h4 class="text-lg font-semibold text-black">Companies Page</h4>
                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-medium">Optimized</span>
                    </div>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Title Tag</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['companies']['title'] ?? 'Top Companies Hiring in Cameroon - HireCameroon' }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Meta Description</label>
                            <p class="text-sm text-gray-600 bg-white p-2 rounded border">{{ $metaTags['companies']['description'] ?? 'Discover top companies hiring in Cameroon. Connect with leading employers across Douala, Yaoundé, and beyond.' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Keywords Tab -->
        <div id="keywords-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Keyword Management</h3>
                <div class="flex items-center space-x-2">
                    <button onclick="addKeyword()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Add Keyword
                    </button>
                    <button onclick="runKeywordResearch()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Research Keywords
                    </button>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Primary Keywords -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Primary Keywords</h4>
                    <div class="space-y-3">
                        @foreach($keywords['primary'] ?? [] as $keyword)
                        <div class="flex items-center justify-between bg-white p-3 rounded-lg">
                            <div>
                                <span class="font-medium text-black">{{ $keyword['term'] }}</span>
                                <span class="ml-2 px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-xs">Vol: {{ number_format($keyword['volume']) }}</span>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="text-sm text-gray-600">Rank: {{ $keyword['rank'] ?? 'N/A' }}</span>
                                <button onclick="editKeyword('{{ $keyword['term'] }}')" class="text-blue-600 hover:text-blue-800">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

                <!-- Secondary Keywords -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Secondary Keywords</h4>
                    <div class="space-y-3">
                        @foreach($keywords['secondary'] ?? [] as $keyword)
                        <div class="flex items-center justify-between bg-white p-3 rounded-lg">
                            <div>
                                <span class="font-medium text-black">{{ $keyword['term'] }}</span>
                                <span class="ml-2 px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Vol: {{ number_format($keyword['volume']) }}</span>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="text-sm text-gray-600">Rank: {{ $keyword['rank'] ?? 'N/A' }}</span>
                                <button onclick="editKeyword('{{ $keyword['term'] }}')" class="text-blue-600 hover:text-blue-800">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Sitemap & Structure Tab -->
        <div id="sitemap-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Site Structure & Sitemap</h3>
                <div class="flex items-center space-x-2">
                    <button onclick="generateSitemap()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Generate Sitemap
                    </button>
                    <button onclick="submitToSearchEngines()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Submit to Search Engines
                    </button>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Site Structure -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Site Structure</h4>
                    <div class="space-y-2 text-sm">
                        <div class="flex items-center">
                            <span class="w-4 h-4 bg-blue-500 rounded mr-2"></span>
                            <span class="text-black font-medium">Homepage</span>
                            <span class="ml-auto text-green-600">Indexed</span>
                        </div>
                        <div class="flex items-center ml-6">
                            <span class="w-3 h-3 bg-green-500 rounded mr-2"></span>
                            <span>Jobs</span>
                            <span class="ml-auto text-green-600">Indexed</span>
                        </div>
                        <div class="flex items-center ml-6">
                            <span class="w-3 h-3 bg-green-500 rounded mr-2"></span>
                            <span>Companies</span>
                            <span class="ml-auto text-green-600">Indexed</span>
                        </div>
                        <div class="flex items-center ml-6">
                            <span class="w-3 h-3 bg-yellow-500 rounded mr-2"></span>
                            <span>Blog/News</span>
                            <span class="ml-auto text-yellow-600">Partial</span>
                        </div>
                        <div class="flex items-center ml-6">
                            <span class="w-3 h-3 bg-red-500 rounded mr-2"></span>
                            <span>About</span>
                            <span class="ml-auto text-red-600">Not Indexed</span>
                        </div>
                    </div>
                </div>

                <!-- Sitemap Status -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Sitemap Status</h4>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-700">Last Generated</span>
                            <span class="text-black font-medium">{{ $sitemapStatus['last_generated'] ?? 'Never' }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-700">Total URLs</span>
                            <span class="text-black font-medium">{{ $sitemapStatus['total_urls'] ?? 0 }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-700">Google Submission</span>
                            <span class="text-green-600 font-medium">Submitted</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-700">Bing Submission</span>
                            <span class="text-green-600 font-medium">Submitted</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Analytics Tab -->
        <div id="analytics-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">SEO Analytics</h3>
                <div class="flex items-center space-x-2">
                    <select id="analyticsPeriod" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="7">Last 7 days</option>
                        <option value="30" selected>Last 30 days</option>
                        <option value="90">Last 90 days</option>
                    </select>
                    <button onclick="refreshAnalytics()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Refresh
                    </button>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Top Pages -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Top Performing Pages</h4>
                    <div class="space-y-3">
                        @foreach($analytics['top_pages'] ?? [] as $page)
                        <div class="flex items-center justify-between bg-white p-3 rounded-lg">
                            <div class="flex-1">
                                <div class="text-sm font-medium text-black truncate">{{ $page['url'] }}</div>
                                <div class="text-xs text-gray-600">{{ number_format($page['views']) }} views</div>
                            </div>
                            <div class="text-right">
                                <div class="text-sm font-medium text-green-600">{{ $page['bounce_rate'] }}%</div>
                                <div class="text-xs text-gray-600">bounce</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

                <!-- Search Queries -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <h4 class="text-lg font-semibold text-black mb-4">Top Search Queries</h4>
                    <div class="space-y-3">
                        @foreach($analytics['search_queries'] ?? [] as $query)
                        <div class="flex items-center justify-between bg-white p-3 rounded-lg">
                            <div class="flex-1">
                                <div class="text-sm font-medium text-black">{{ $query['term'] }}</div>
                                <div class="text-xs text-gray-600">{{ $query['position'] }} position</div>
                            </div>
                            <div class="text-right">
                                <div class="text-sm font-medium text-blue-600">{{ number_format($query['clicks']) }}</div>
                                <div class="text-xs text-gray-600">clicks</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Meta Editor Modal -->
    <div id="metaEditorModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-4/5 shadow-lg rounded-md bg-white max-h-screen overflow-y-auto">
            <div class="mt-3">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Edit Meta Tags</h3>
                    <button onclick="closeMetaEditorModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <form id="metaEditorForm" class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Page</label>
                        <select name="page" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="home">Homepage</option>
                            <option value="jobs">Jobs Page</option>
                            <option value="companies">Companies Page</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Title Tag</label>
                        <input type="text" name="title" maxlength="60" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <p class="text-xs text-gray-500 mt-1">Recommended: 50-60 characters</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Meta Description</label>
                        <textarea name="description" rows="3" maxlength="160" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent resize-none"></textarea>
                        <p class="text-xs text-gray-500 mt-1">Recommended: 150-160 characters</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Keywords (comma-separated)</label>
                        <input type="text" name="keywords" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>

                    <div class="flex items-center justify-end space-x-4">
                        <button type="button" onclick="closeMetaEditorModal()" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">Cancel</button>
                        <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        let currentSEOTab = 'meta';

        document.addEventListener('DOMContentLoaded', function() {
            // Tab switching
            document.querySelectorAll('.tab-button').forEach(button => {
                button.addEventListener('click', function() {
                    const tabName = this.id.replace('-tab', '');
                    switchSEOTab(tabName);
                });
            });

            // Form submissions
            document.getElementById('metaEditorForm').addEventListener('submit', function(e) {
                e.preventDefault();
                saveMetaTags();
            });
        });

        function switchSEOTab(tabName) {
            // Update tab buttons
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active', 'border-b-2', 'border-blue-500', 'text-blue-600');
                button.classList.add('text-gray-500');
            });

            document.getElementById(tabName + '-tab').classList.add('active', 'border-b-2', 'border-blue-500', 'text-blue-600');

            // Update content visibility
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });

            document.getElementById(tabName + '-content').classList.remove('hidden');

            currentSEOTab = tabName;
        }

        function openMetaEditorModal() {
            document.getElementById('metaEditorModal').classList.remove('hidden');
        }

        function closeMetaEditorModal() {
            document.getElementById('metaEditorModal').classList.add('hidden');
            document.getElementById('metaEditorForm').reset();
        }

        function saveMetaTags() {
            const formData = new FormData(document.getElementById('metaEditorForm'));

            fetch('/admin/seo-management/meta-tags', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeMetaEditorModal();
                    location.reload(); // Refresh to show updated meta tags
                    showSuccess('Meta tags updated successfully');
                } else {
                    showError(data.message || 'Failed to update meta tags');
                }
            })
            .catch(error => {
                console.error('Error updating meta tags:', error);
                showError('Failed to update meta tags');
            });
        }

        function addKeyword() {
            const keyword = prompt('Enter new keyword:');
            if (keyword) {
                fetch('/admin/seo-management/keywords', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ keyword: keyword })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                        showSuccess('Keyword added successfully');
                    } else {
                        showError(data.message || 'Failed to add keyword');
                    }
                })
                .catch(error => {
                    console.error('Error adding keyword:', error);
                    showError('Failed to add keyword');
                });
            }
        }

        function editKeyword(keyword) {
            const newKeyword = prompt('Edit keyword:', keyword);
            if (newKeyword && newKeyword !== keyword) {
                fetch(`/admin/seo-management/keywords/${encodeURIComponent(keyword)}`, {
                    method: 'PUT',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ keyword: newKeyword })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                        showSuccess('Keyword updated successfully');
                    } else {
                        showError(data.message || 'Failed to update keyword');
                    }
                })
                .catch(error => {
                    console.error('Error updating keyword:', error);
                    showError('Failed to update keyword');
                });
            }
        }

        function runKeywordResearch() {
            fetch('/admin/seo-management/keyword-research', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showSuccess('Keyword research completed');
                    setTimeout(() => location.reload(), 2000);
                } else {
                    showError(data.message || 'Keyword research failed');
                }
            })
            .catch(error => {
                console.error('Error running keyword research:', error);
                showError('Keyword research failed');
            });
        }

        function generateSitemap() {
            fetch('/admin/seo-management/generate-sitemap', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showSuccess('Sitemap generated successfully');
                    setTimeout(() => location.reload(), 2000);
                } else {
                    showError(data.message || 'Failed to generate sitemap');
                }
            })
            .catch(error => {
                console.error('Error generating sitemap:', error);
                showError('Failed to generate sitemap');
            });
        }

        function submitToSearchEngines() {
            fetch('/admin/seo-management/submit-sitemap', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showSuccess('Sitemap submitted to search engines');
                } else {
                    showError(data.message || 'Failed to submit sitemap');
                }
            })
            .catch(error => {
                console.error('Error submitting sitemap:', error);
                showError('Failed to submit sitemap');
            });
        }

        function refreshAnalytics() {
            const period = document.getElementById('analyticsPeriod').value;

            fetch(`/admin/seo-management/analytics?period=${period}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update analytics data on page
                    updateAnalyticsDisplay(data.analytics);
                    showSuccess('Analytics refreshed');
                } else {
                    showError(data.message || 'Failed to refresh analytics');
                }
            })
            .catch(error => {
                console.error('Error refreshing analytics:', error);
                showError('Failed to refresh analytics');
            });
        }

        function updateAnalyticsDisplay(analytics) {
            // This would update the analytics display with new data
            // Implementation depends on how the analytics are displayed
        }

        function showSuccess(message) {
            // Simple success notification
            alert(message);
        }

        function showError(message) {
            // Simple error notification
            alert(message);
        }
    </script>
</x-layouts.app>