<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="w-10 h-10 bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <div>
                    <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                        System Settings
                    </h2>
                    <p class="text-sm text-gray-600">Configure platform settings and preferences</p>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-sm font-medium">
                    Admin Mode
                </span>
            </div>
        </div>
    </x-slot>

    <form method="POST" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data" class="space-y-8">
        @csrf

        <!-- General Settings -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">General Settings</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Site Name -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Site Name *</label>
                    <input type="text" name="site_name" value="{{ old('site_name', $settings['site_name'] ?? 'Hire Cameroon') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 @error('site_name') border-red-500 @enderror"
                           placeholder="e.g. Hire Cameroon">
                    @error('site_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Site Description -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Site Description</label>
                    <input type="text" name="site_description" value="{{ old('site_description', $settings['site_description'] ?? '') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300"
                           placeholder="Brief description of your platform">
                </div>

                <!-- Contact Email -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Contact Email *</label>
                    <input type="email" name="contact_email" value="{{ old('contact_email', $settings['contact_email'] ?? 'admin@hirecameroon.com') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 @error('contact_email') border-red-500 @enderror"
                           placeholder="admin@yourdomain.com">
                    @error('contact_email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Default Currency -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Default Currency</label>
                    <select name="default_currency" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300">
                        <option value="XAF" {{ ($settings['default_currency'] ?? 'XAF') == 'XAF' ? 'selected' : '' }}>XAF (Central African Franc)</option>
                        <option value="USD" {{ ($settings['default_currency'] ?? 'XAF') == 'USD' ? 'selected' : '' }}>USD (US Dollar)</option>
                        <option value="EUR" {{ ($settings['default_currency'] ?? 'XAF') == 'EUR' ? 'selected' : '' }}>EUR (Euro)</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Platform Features -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Platform Features</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Registration Enabled -->
                <div class="flex items-center">
                    <input type="checkbox" id="registration_enabled" name="registration_enabled" value="1"
                           {{ ($settings['registration_enabled'] ?? true) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-green-600 focus:ring-green-500 focus:ring-2 transition-all duration-200">
                    <label for="registration_enabled" class="ml-3 text-gray-700 font-medium">Allow new user registrations</label>
                </div>

                <!-- Job Posting Enabled -->
                <div class="flex items-center">
                    <input type="checkbox" id="job_posting_enabled" name="job_posting_enabled" value="1"
                           {{ ($settings['job_posting_enabled'] ?? true) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-green-600 focus:ring-green-500 focus:ring-2 transition-all duration-200">
                    <label for="job_posting_enabled" class="ml-3 text-gray-700 font-medium">Allow job postings</label>
                </div>

                <!-- Email Notifications -->
                <div class="flex items-center">
                    <input type="checkbox" id="email_notifications" name="email_notifications" value="1"
                           {{ ($settings['email_notifications'] ?? true) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-green-600 focus:ring-green-500 focus:ring-2 transition-all duration-200">
                    <label for="email_notifications" class="ml-3 text-gray-700 font-medium">Enable email notifications</label>
                </div>

                <!-- Featured Jobs -->
                <div class="flex items-center">
                    <input type="checkbox" id="featured_jobs_enabled" name="featured_jobs_enabled" value="1"
                           {{ ($settings['featured_jobs_enabled'] ?? true) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-green-600 focus:ring-green-500 focus:ring-2 transition-all duration-200">
                    <label for="featured_jobs_enabled" class="ml-3 text-gray-700 font-medium">Enable featured jobs</label>
                </div>
            </div>
        </div>

        <!-- Maintenance & Security -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Maintenance & Security</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Maintenance Mode -->
                <div class="flex items-center">
                    <input type="checkbox" id="maintenance_mode" name="maintenance_mode" value="1"
                           {{ ($settings['maintenance_mode'] ?? false) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-red-600 focus:ring-red-500 focus:ring-2 transition-all duration-200">
                    <label for="maintenance_mode" class="ml-3 text-gray-700 font-medium">Enable maintenance mode</label>
                </div>

                <!-- Debug Mode -->
                <div class="flex items-center">
                    <input type="checkbox" id="debug_mode" name="debug_mode" value="1"
                           {{ ($settings['debug_mode'] ?? false) ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-red-600 focus:ring-red-500 focus:ring-2 transition-all duration-200">
                    <label for="debug_mode" class="ml-3 text-gray-700 font-medium">Enable debug mode</label>
                </div>

                <!-- Session Timeout -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Session Timeout (minutes)</label>
                    <input type="number" name="session_timeout" value="{{ old('session_timeout', $settings['session_timeout'] ?? 1440) }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-red-500/20 focus:border-red-500 transition-all duration-300"
                           placeholder="1440" min="30" max="10080">
                </div>

                <!-- Max Login Attempts -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Max Login Attempts</label>
                    <input type="number" name="max_login_attempts" value="{{ old('max_login_attempts', $settings['max_login_attempts'] ?? 5) }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-red-500/20 focus:border-red-500 transition-all duration-300"
                           placeholder="5" min="3" max="20">
                </div>
            </div>
        </div>

        <!-- Appearance & Branding -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-pink-500 to-pink-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zM21 5a2 2 0 00-2-2h-4a2 2 0 00-2 2v12a4 4 0 004 4h4a2 2 0 002-2V5z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Appearance & Branding</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Logo Upload -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Site Logo</label>
                    <input type="file" name="logo" accept="image/*"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                    @if($settings['logo_url'] ?? false)
                        <div class="mt-2">
                            <img src="{{ Storage::disk('public')->url($settings['logo_url']) }}" alt="Current Logo" class="h-12 w-auto rounded">
                            <p class="text-sm text-gray-500 mt-1">Current logo</p>
                        </div>
                    @endif
                </div>

                <!-- Favicon Upload -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Favicon</label>
                    <input type="file" name="favicon" accept="image/*"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                    @if($settings['favicon_url'] ?? false)
                        <div class="mt-2">
                            <img src="{{ Storage::disk('public')->url($settings['favicon_url']) }}" alt="Current Favicon" class="h-8 w-8 rounded">
                            <p class="text-sm text-gray-500 mt-1">Current favicon</p>
                        </div>
                    @endif
                </div>

                <!-- Primary Color -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Primary Color</label>
                    <input type="color" name="primary_color" value="{{ old('primary_color', $settings['primary_color'] ?? '#3B82F6') }}"
                            class="w-full h-12 px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                </div>

                <!-- Secondary Color -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Secondary Color</label>
                    <input type="color" name="secondary_color" value="{{ old('secondary_color', $settings['secondary_color'] ?? '#6B7280') }}"
                            class="w-full h-12 px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                </div>
            </div>
        </div>

        <!-- Subscription Plans -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Subscription Plans</h3>
            </div>

            <div id="subscription-plans">
                @php $plans = $settings['subscription_plans'] ?? ['basic' => ['name' => 'Basic', 'price' => 0, 'features' => ['5 jobs/month', 'Basic support']]]; @endphp
                @foreach($plans as $key => $plan)
                <div class="plan-item border border-gray-200 rounded-xl p-4 mb-4">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Plan Name</label>
                            <input type="text" name="subscription_plans[{{ $key }}][name]" value="{{ $plan['name'] }}"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Price (XAF)</label>
                            <input type="number" name="subscription_plans[{{ $key }}][price]" value="{{ $plan['price'] }}"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Features (comma-separated)</label>
                            <input type="text" name="subscription_plans[{{ $key }}][features]" value="{{ is_array($plan['features']) ? implode(', ', $plan['features']) : $plan['features'] }}"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Backup Settings -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-cyan-500 to-cyan-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Backup Management</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Auto Backup -->
                <div class="flex items-center">
                    <input type="checkbox" id="auto_backup_enabled" name="auto_backup_enabled" value="1"
                            {{ ($settings['auto_backup_enabled'] ?? false) ? 'checked' : '' }}
                            class="w-5 h-5 rounded border-2 border-gray-300 text-cyan-600 focus:ring-cyan-500 focus:ring-2 transition-all duration-200">
                    <label for="auto_backup_enabled" class="ml-3 text-gray-700 font-medium">Enable automatic backups</label>
                </div>

                <!-- Backup Frequency -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Backup Frequency</label>
                    <select name="backup_frequency" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-cyan-500/20 focus:border-cyan-500 transition-all duration-300">
                        <option value="daily" {{ ($settings['backup_frequency'] ?? 'daily') == 'daily' ? 'selected' : '' }}>Daily</option>
                        <option value="weekly" {{ ($settings['backup_frequency'] ?? 'daily') == 'weekly' ? 'selected' : '' }}>Weekly</option>
                        <option value="monthly" {{ ($settings['backup_frequency'] ?? 'daily') == 'monthly' ? 'selected' : '' }}>Monthly</option>
                    </select>
                </div>

                <!-- Retention Days -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Backup Retention (days)</label>
                    <input type="number" name="backup_retention_days" value="{{ old('backup_retention_days', $settings['backup_retention_days'] ?? 30) }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-cyan-500/20 focus:border-cyan-500 transition-all duration-300"
                            placeholder="30" min="1" max="365">
                </div>

                <!-- Manual Backup Button -->
                <div class="flex items-end">
                    <a href="{{ route('admin.backup.create') }}" class="bg-gradient-to-r from-cyan-500 to-cyan-600 hover:from-cyan-600 hover:to-cyan-700 text-white font-bold px-6 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 hover:-translate-y-1 flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Create Backup Now
                    </a>
                </div>
            </div>
        </div>

        <!-- Platform Customization -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-1a2 2 0 100 4h1a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-1a2 2 0 10-4 0v1a1 1 0 01-1 1H7a1 1 0 01-1-1v-3a1 1 0 011-1h1a2 2 0 100-4H7a1 1 0 01-1-1V7a1 1 0 011-1h3a1 1 0 011-1V4z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Platform Customization</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Welcome Message -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Welcome Message</label>
                    <input type="text" name="welcome_message" value="{{ old('welcome_message', $settings['welcome_message'] ?? 'Welcome to Hire Cameroon') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                            placeholder="Welcome message for homepage">
                </div>

                <!-- Footer Text -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Footer Text</label>
                    <input type="text" name="footer_text" value="{{ old('footer_text', $settings['footer_text'] ?? '© 2025 Hire Cameroon. All rights reserved.') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                            placeholder="Copyright text for footer">
                </div>

                <!-- Social Links -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Social Media Links</label>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <input type="url" name="social_links[facebook]" value="{{ old('social_links.facebook', ($settings['social_links']['facebook'] ?? '')) }}"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                                    placeholder="Facebook URL">
                        </div>
                        <div>
                            <input type="url" name="social_links[twitter]" value="{{ old('social_links.twitter', ($settings['social_links']['twitter'] ?? '')) }}"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                                    placeholder="Twitter URL">
                        </div>
                        <div>
                            <input type="url" name="social_links[linkedin]" value="{{ old('social_links.linkedin', ($settings['social_links']['linkedin'] ?? '')) }}"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                                    placeholder="LinkedIn URL">
                        </div>
                    </div>
                </div>

                <!-- Custom CSS -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Custom CSS</label>
                    <textarea name="custom_css" rows="6"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                            placeholder="Add custom CSS styles here...">{{ old('custom_css', $settings['custom_css'] ?? '') }}</textarea>
                </div>
            </div>
        </div>

        <!-- Email Settings -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Email Configuration</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- SMTP Host -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">SMTP Host</label>
                    <input type="text" name="smtp_host" value="{{ old('smtp_host', $settings['smtp_host'] ?? '') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300"
                            placeholder="smtp.gmail.com">
                </div>

                <!-- SMTP Port -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">SMTP Port</label>
                    <input type="number" name="smtp_port" value="{{ old('smtp_port', $settings['smtp_port'] ?? 587) }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300"
                            placeholder="587">
                </div>

                <!-- SMTP Username -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">SMTP Username</label>
                    <input type="text" name="smtp_username" value="{{ old('smtp_username', $settings['smtp_username'] ?? '') }}"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300"
                            placeholder="your-email@gmail.com">
                </div>

                <!-- SMTP Encryption -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">SMTP Encryption</label>
                    <select name="smtp_encryption" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300">
                        <option value="tls" {{ ($settings['smtp_encryption'] ?? 'tls') == 'tls' ? 'selected' : '' }}>TLS</option>
                        <option value="ssl" {{ ($settings['smtp_encryption'] ?? 'tls') == 'ssl' ? 'selected' : '' }}>SSL</option>
                        <option value="none" {{ ($settings['smtp_encryption'] ?? 'tls') == 'none' ? 'selected' : '' }}>None</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Submit Actions -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex flex-col sm:flex-row gap-4 justify-end">
                <button type="submit" class="bg-gradient-to-r from-indigo-500 to-indigo-600 hover:from-indigo-600 hover:to-indigo-700 text-white font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 hover:-translate-y-1 flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Save Settings
                </button>
            </div>
        </div>
    </form>
</x-layouts.app>