@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-2xl font-semibold">My Advertisements</h1>
        <a href="{{ route('ads.create') }}" class="px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700 transition">Create New Ad</a>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="text-sm font-medium text-gray-500 mb-1">Active Ads</div>
            <div class="text-2xl font-semibold">{{ $ads->where('status', 'active')->count() }}</div>
        </div>
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="text-sm font-medium text-gray-500 mb-1">Total Impressions</div>
            <div class="text-2xl font-semibold">{{ number_format($totalImpressions) }}</div>
        </div>
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="text-sm font-medium text-gray-500 mb-1">Total Clicks</div>
            <div class="text-2xl font-semibold">{{ number_format($totalClicks) }}</div>
        </div>
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="text-sm font-medium text-gray-500 mb-1">Average CTR</div>
            <div class="text-2xl font-semibold">{{ number_format($avgCtr, 2) }}%</div>
        </div>
    </div>

    @if($ads->isEmpty())
        <div class="p-6 bg-white shadow rounded">You have no ads yet. Click "Create New Ad" to start.</div>
    @else
        <!-- Filters -->
        <div class="bg-white p-4 rounded-lg shadow mb-6">
            <div class="flex flex-wrap gap-4">
                <button class="px-4 py-2 rounded {{ $filter === 'all' ? 'bg-indigo-100 text-indigo-700' : 'bg-gray-100' }}" 
                        onclick="window.location.href='{{ route('ads.index') }}'">
                    All Ads
                </button>
                <button class="px-4 py-2 rounded {{ $filter === 'active' ? 'bg-green-100 text-green-700' : 'bg-gray-100' }}"
                        onclick="window.location.href='{{ route('ads.index', ['filter' => 'active']) }}'">
                    Active
                </button>
                <button class="px-4 py-2 rounded {{ $filter === 'pending' ? 'bg-yellow-100 text-yellow-700' : 'bg-gray-100' }}"
                        onclick="window.location.href='{{ route('ads.index', ['filter' => 'pending']) }}'">
                    Pending
                </button>
                <button class="px-4 py-2 rounded {{ $filter === 'expired' ? 'bg-red-100 text-red-700' : 'bg-gray-100' }}"
                        onclick="window.location.href='{{ route('ads.index', ['filter' => 'expired']) }}'">
                    Expired
                </button>
            </div>
        </div>

        <!-- Ads List -->
        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
            @foreach($ads as $ad)
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <!-- Preview -->
                    <div class="aspect-video bg-gray-100 relative">
                        @if($ad->type === 'video')
                            <img src="{{ Storage::url($ad->poster_path) }}" 
                                alt="{{ $ad->title }}" 
                                class="w-full h-full object-cover">
                            <div class="absolute inset-0 flex items-center justify-center">
                                <svg class="w-12 h-12 text-white opacity-80" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M6.3 2.841A1.5 1.5 0 004 4.11v11.78a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"/>
                                </svg>
                            </div>
                        @elseif($ad->type === 'image')
                            <img src="{{ Storage::url($ad->image_path) }}" 
                                alt="{{ $ad->title }}" 
                                class="w-full h-full object-cover">
                        @else
                            <div class="w-full h-full flex items-center justify-center p-4">
                                <div class="text-lg font-medium text-gray-900">{{ $ad->title }}</div>
                            </div>
                        @endif

                        <!-- Status Badge -->
                        <div class="absolute top-2 right-2">
                            @switch($ad->status)
                                @case('active')
                                    <span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">Active</span>
                                    @break
                                @case('pending')
                                @case('pending_payment')
                                    <span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">Pending</span>
                                    @break
                                @case('expired')
                                    <span class="px-2 py-1 text-xs rounded bg-red-100 text-red-800">Expired</span>
                                    @break
                                @default
                                    <span class="px-2 py-1 text-xs rounded bg-gray-100 text-gray-800">{{ ucfirst($ad->status) }}</span>
                            @endswitch
                        </div>
                    </div>

                    <!-- Details -->
                    <div class="p-4">
                        <h3 class="font-medium text-lg mb-2">{{ $ad->title ?? 'Untitled Ad' }}</h3>
                        
                        <!-- Metrics -->
                        <div class="grid grid-cols-3 gap-4 mb-4 text-sm">
                            <div>
                                <div class="text-gray-500">Impressions</div>
                                <div class="font-medium">{{ number_format($ad->metrics['total_impressions'] ?? 0) }}</div>
                            </div>
                            <div>
                                <div class="text-gray-500">Clicks</div>
                                <div class="font-medium">{{ number_format($ad->metrics['total_clicks'] ?? 0) }}</div>
                            </div>
                            <div>
                                <div class="text-gray-500">CTR</div>
                                <div class="font-medium">{{ number_format($ad->metrics['ctr'] ?? 0, 2) }}%</div>
                            </div>
                        </div>

                        <!-- Period -->
                        <div class="text-sm text-gray-500 mb-4">
                            {{ $ad->start_at ? Carbon\Carbon::parse($ad->start_at)->format('M j, Y') : 'Not started' }} — 
                            {{ $ad->end_at ? Carbon\Carbon::parse($ad->end_at)->format('M j, Y') : 'No end date' }}
                        </div>

                        <!-- Actions -->
                        <div class="flex justify-between items-center">
                            <a href="{{ route('ads.show', $ad) }}" 
                               class="text-sm text-indigo-600 hover:text-indigo-800">View Details</a>
                            
                            @if($ad->status === 'active')
                                <span class="text-sm text-green-600">● Live</span>
                            @elseif(in_array($ad->status, ['pending', 'pending_payment']))
                                <a href="{{ route('ads.show', $ad) }}" 
                                   class="text-sm text-yellow-600 hover:text-yellow-800">Complete Setup</a>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>
@endsection
