@extends('layouts.app')

@section('header')
    <h2 class="font-semibold text-xl text-gray-800 leading-tight">
        {{ __('My Applications') }}
    </h2>
@endsection

@section('content')
    <!-- Applications List -->
    <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
        <div class="p-6 bg-gradient-to-r from-black via-gray-900 to-black text-white">
            <div class="max-w-7xl mx-auto">
                <h1 class="text-3xl font-bold mb-2">Your Job Applications</h1>
                <p class="text-gray-300">Track and manage all your job applications in one place.</p>
            </div>
        </div>

        <div class="p-6">
            @forelse($applications as $application)
            <div class="bg-white border-2 border-gray-100 rounded-2xl p-6 mb-6 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
                <!-- Application Header -->
                <div class="flex items-start justify-between mb-4">
                    <div class="flex items-start">
                        <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-2xl flex items-center justify-center mr-4 shadow-lg">
                            <span class="text-black font-bold text-xl">{{ substr($application->job->company->name ?? 'C', 0, 1) }}</span>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-black mb-1">{{ $application->job->title }}</h3>
                            <p class="text-gray-600 font-medium">{{ $application->job->company->name ?? 'Company Name' }}</p>
                            <div class="flex items-center mt-2 text-sm text-gray-500">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                {{ $application->job->location }}
                                <span class="mx-2">•</span>
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Applied {{ $application->created_at->diffForHumans() }}
                            </div>
                        </div>
                    </div>

                    <!-- Status Badge -->
                    <div class="text-right">
                        @php
                            $statusColors = [
                                'pending' => 'bg-gray-100 text-gray-800',
                                'reviewing' => 'bg-blue-100 text-blue-800',
                                'shortlisted' => 'bg-yellow-100 text-yellow-800',
                                'interviewed' => 'bg-purple-100 text-purple-800',
                                'offered' => 'bg-green-100 text-green-800',
                                'rejected' => 'bg-red-100 text-red-800',
                                'withdrawn' => 'bg-gray-100 text-gray-600'
                            ];
                            $statusLabels = [
                                'pending' => 'Pending Review',
                                'reviewing' => 'Under Review',
                                'shortlisted' => 'Shortlisted',
                                'interviewed' => 'Interview Scheduled',
                                'offered' => 'Offer Extended',
                                'rejected' => 'Not Selected',
                                'withdrawn' => 'Withdrawn'
                            ];
                        @endphp
                        <span class="px-3 py-1 rounded-full text-sm font-bold {{ $statusColors[$application->status] ?? 'bg-gray-100 text-gray-800' }}">
                            {{ $statusLabels[$application->status] ?? ucfirst($application->status) }}
                        </span>
                        @if($application->job->featured)
                        <div class="mt-2">
                            <span class="bg-gradient-to-r from-yellow-400 to-yellow-500 text-black px-2 py-1 rounded-full text-xs font-bold">
                                FEATURED JOB
                            </span>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Application Details -->
                <div class="grid md:grid-cols-2 gap-6 mb-4">
                    <div>
                        <h4 class="font-bold text-black mb-2">Application Details</h4>
                        <div class="space-y-2 text-sm">
                            @if($application->expected_salary)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Expected Salary:</span>
                                <span class="font-bold text-black">XAF {{ number_format($application->expected_salary) }}</span>
                            </div>
                            @endif
                            @if($application->availability_date)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Available From:</span>
                                <span class="font-bold text-black">{{ $application->availability_date->format('M j, Y') }}</span>
                            </div>
                            @endif
                            @if($application->resume_path)
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Resume:</span>
                                <a href="{{ route('applications.download-resume', $application) }}"
                                   class="bg-gradient-to-r from-yellow-400 to-yellow-500 text-black px-3 py-1 rounded-lg text-sm font-bold hover:shadow-lg transition">
                                    Download
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div>
                        <h4 class="font-bold text-black mb-2">Job Information</h4>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Salary Range:</span>
                                <span class="font-bold text-black">
                                    XAF {{ number_format($application->job->salary_min ?? 0) }} -
                                    {{ number_format($application->job->salary_max ?? 0) }}
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Employment Type:</span>
                                <span class="font-bold text-black">{{ $application->job->employment_type ?? 'Full-time' }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Applications:</span>
                                <span class="font-bold text-black">{{ $application->job->applications_count ?? 0 }} total</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Cover Letter Preview -->
                @if($application->cover_letter)
                <div class="mb-4">
                    <h4 class="font-bold text-black mb-2">Cover Letter</h4>
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <p class="text-gray-700 text-sm leading-relaxed">{{ Str::limit($application->cover_letter, 300) }}</p>
                        @if(strlen($application->cover_letter) > 300)
                        <button class="text-yellow-600 font-bold text-sm mt-2 hover:text-yellow-700" onclick="toggleCoverLetter(this)">
                            Read More
                        </button>
                        <div class="hidden mt-2">
                            <p class="text-gray-700 text-sm leading-relaxed">{{ $application->cover_letter }}</p>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Employer Notes (if any) -->
                @if($application->employer_notes)
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-4">
                    <h4 class="font-bold text-blue-900 mb-2 flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                        </svg>
                        Message from Employer
                    </h4>
                    <p class="text-blue-800 text-sm">{{ $application->employer_notes }}</p>
                </div>
                @endif

                <!-- Actions -->
                <div class="flex items-center justify-between pt-4 border-t border-gray-100">
                    <div class="flex items-center text-sm text-gray-500">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Application #{{ $application->id }}
                    </div>
                    <div class="flex gap-3">
                        <a href="{{ route('jobs.show', $application->job) }}"
                           class="bg-yellow-400 hover:bg-yellow-500 text-black px-4 py-2 rounded-lg font-bold text-sm transition">
                            View Job
                        </a>
                        @if($application->status === 'pending')
                        <form method="POST" action="{{ route('applications.withdraw', $application) }}"
                              onsubmit="return confirm('Are you sure you want to withdraw this application?')">
                            @csrf
                            @method('PATCH')
                            <button type="submit" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg font-bold text-sm transition">
                                Withdraw
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
            @empty
            <div class="text-center py-12">
                <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No applications yet</h3>
                <p class="text-gray-600 mb-6">Start applying to jobs to see your applications here.</p>
                <a href="{{ route('jobs.index') }}" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-6 py-3 rounded-lg transition">
                    Browse Jobs
                </a>
            </div>
            @endforelse

            <!-- Pagination -->
            @if($applications->hasPages())
            <div class="mt-8">
                {{ $applications->links() }}
            </div>
            @endif
        </div>
    </div>

    <script>
    function toggleCoverLetter(button) {
        const hiddenContent = button.nextElementSibling;
        if (hiddenContent.classList.contains('hidden')) {
            hiddenContent.classList.remove('hidden');
            button.textContent = 'Read Less';
        } else {
            hiddenContent.classList.add('hidden');
            button.textContent = 'Read More';
        }
    }
    </script>
@endsection