<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Register Your Company - Step-by-Step Setup') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-8">
                    <!-- Progress Steps -->
                    <div class="mb-8">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 step-circle step-active flex items-center justify-center text-sm font-semibold rounded-full" data-step="1">1</div>
                                <div class="step-line w-12 h-0.5 bg-gray-300"></div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 step-circle step-inactive flex items-center justify-center text-sm font-semibold rounded-full" data-step="2">2</div>
                                <div class="step-line w-12 h-0.5 bg-gray-300"></div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 step-circle step-inactive flex items-center justify-center text-sm font-semibold rounded-full" data-step="3">3</div>
                                <div class="step-line w-12 h-0.5 bg-gray-300"></div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 step-circle step-inactive flex items-center justify-center text-sm font-semibold rounded-full" data-step="4">4</div>
                                <div class="step-line w-12 h-0.5 bg-gray-300"></div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 step-circle step-inactive flex items-center justify-center text-sm font-semibold rounded-full" data-step="5">5</div>
                            </div>
                        </div>
                        <div class="flex justify-between mt-3 text-sm font-medium">
                            <span class="step-label-active">Basic Info</span>
                            <span class="step-label-inactive">Business Details</span>
                            <span class="step-label-inactive">Contact Info</span>
                            <span class="step-label-inactive">Company Culture</span>
                            <span class="step-label-inactive">Complete</span>
                        </div>
                    </div>

                    <form method="POST" action="{{ route('companies.store') }}" id="companyForm" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Step 1: Basic Company Information -->
                        <div class="form-step" data-step="1">
                            <div class="mb-6">
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Step 1: Basic Company Information</h3>
                                <p class="text-gray-600">Let's start with the fundamental details about your company.</p>
                            </div>
                            
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="md:col-span-2">
                                        <x-input-label for="name" :value="__('Company Name')" />
                                        <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" value="{{ old('name') }}" required />
                                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="registration_no" :value="__('Registration Number')" />
                                        <x-text-input id="registration_no" name="registration_no" type="text" class="mt-1 block w-full" value="{{ old('registration_no') }}" placeholder="RC/DLA/2023/123456" />
                                        <x-input-error :messages="$errors->get('registration_no')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="tax_id" :value="__('Tax ID (Optional)')" />
                                        <x-text-input id="tax_id" name="tax_id" type="text" class="mt-1 block w-full" value="{{ old('tax_id') }}" placeholder="M051234567890A" />
                                        <x-input-error :messages="$errors->get('tax_id')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="business_license" :value="__('Business License (Optional)')" />
                                        <x-text-input id="business_license" name="business_license" type="text" class="mt-1 block w-full" value="{{ old('business_license') }}" placeholder="BL-2023-001234" />
                                        <x-input-error :messages="$errors->get('business_license')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="website" :value="__('Company Website')" />
                                        <x-text-input id="website" name="website" type="url" class="mt-1 block w-full" value="{{ old('website') }}" placeholder="https://www.yourcompany.com" />
                                        <x-input-error :messages="$errors->get('website')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="sector" :value="__('Primary Business Sector')" />
                                        <select id="sector" name="sector" class="mt-1 block w-full border-gray-300 rounded-md" required>
                                            <option value="">Select primary sector</option>
                                            <option value="Technology" {{ old('sector') == 'Technology' ? 'selected' : '' }}>Technology & IT Services</option>
                                            <option value="Healthcare" {{ old('sector') == 'Healthcare' ? 'selected' : '' }}>Healthcare & Medical Services</option>
                                            <option value="Finance" {{ old('sector') == 'Finance' ? 'selected' : '' }}>Finance & Banking</option>
                                            <option value="Education" {{ old('sector') == 'Education' ? 'selected' : '' }}>Education & Training</option>
                                            <option value="Manufacturing" {{ old('sector') == 'Manufacturing' ? 'selected' : '' }}>Manufacturing & Production</option>
                                            <option value="Retail" {{ old('sector') == 'Retail' ? 'selected' : '' }}>Retail & E-commerce</option>
                                            <option value="Agriculture" {{ old('sector') == 'Agriculture' ? 'selected' : '' }}>Agriculture & Agribusiness</option>
                                            <option value="Tourism" {{ old('sector') == 'Tourism' ? 'selected' : '' }}>Tourism & Hospitality</option>
                                            <option value="Construction" {{ old('sector') == 'Construction' ? 'selected' : '' }}>Construction & Real Estate</option>
                                            <option value="Transportation" {{ old('sector') == 'Transportation' ? 'selected' : '' }}>Transportation & Logistics</option>
                                            <option value="Telecommunications" {{ old('sector') == 'Telecommunications' ? 'selected' : '' }}>Telecommunications</option>
                                            <option value="Oil Gas" {{ old('sector') == 'Oil Gas' ? 'selected' : '' }}>Oil, Gas & Energy</option>
                                            <option value="Media" {{ old('sector') == 'Media' ? 'selected' : '' }}>Media & Entertainment</option>
                                            <option value="Consulting" {{ old('sector') == 'Consulting' ? 'selected' : '' }}>Consulting & Professional Services</option>
                                            <option value="Non-Profit" {{ old('sector') == 'Non-Profit' ? 'selected' : '' }}>Non-Profit & NGO</option>
                                            <option value="Government" {{ old('sector') == 'Government' ? 'selected' : '' }}>Government & Public Sector</option>
                                            <option value="Other" {{ old('sector') == 'Other' ? 'selected' : '' }}>Other</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('sector')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="description" :value="__('Company Description')" />
                                        <textarea id="description" name="description" rows="4" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Tell us about your company mission, vision, what you do, and what makes you unique...">{{ old('description') }}</textarea>
                                        <x-input-error :messages="$errors->get('description')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Step 2: Business Details & Legal Information -->
                        <div class="form-step hidden" data-step="2">
                            <div class="mb-6">
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Step 2: Business Details & Legal Information</h3>
                                <p class="text-gray-600">Provide additional business information and company structure details.</p>
                            </div>
                            
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <x-input-label for="size" :value="__('Company Size')" />
                                        <select id="size" name="size" class="mt-1 block w-full border-gray-300 rounded-md">
                                            <option value="">Select company size</option>
                                            <option value="1-10" {{ old('size') == '1-10' ? 'selected' : '' }}>1-10 employees (Startup)</option>
                                            <option value="11-50" {{ old('size') == '11-50' ? 'selected' : '' }}>11-50 employees (Small)</option>
                                            <option value="51-200" {{ old('size') == '51-200' ? 'selected' : '' }}>51-200 employees (Medium)</option>
                                            <option value="201-500" {{ old('size') == '201-500' ? 'selected' : '' }}>201-500 employees (Large)</option>
                                            <option value="500-1000" {{ old('size') == '500-1000' ? 'selected' : '' }}>500-1000 employees (Very Large)</option>
                                            <option value="1000+" {{ old('size') == '1000+' ? 'selected' : '' }}>1000+ employees (Enterprise)</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('size')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="num_offices" :value="__('Number of Offices')" />
                                        <select id="num_offices" name="num_offices" class="mt-1 block w-full border-gray-300 rounded-md">
                                            <option value="">Select office count</option>
                                            <option value="1" {{ old('num_offices') == '1' ? 'selected' : '' }}>1 (Single Location)</option>
                                            <option value="2-5" {{ old('num_offices') == '2-5' ? 'selected' : '' }}>2-5 Locations</option>
                                            <option value="6-20" {{ old('num_offices') == '6-20' ? 'selected' : '' }}>6-20 Locations</option>
                                            <option value="20+" {{ old('num_offices') == '20+' ? 'selected' : '' }}>20+ Locations (Multinational)</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('num_offices')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="founded_year" :value="__('Year Founded')" />
                                        <x-text-input id="founded_year" name="founded_year" type="number" class="mt-1 block w-full" value="{{ old('founded_year') }}" min="1800" max="{{ date('Y') }}" placeholder="2020" />
                                        <x-input-error :messages="$errors->get('founded_year')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="ceo_name" :value="__('CEO/Managing Director Name')" />
                                        <x-text-input id="ceo_name" name="ceo_name" type="text" class="mt-1 block w-full" value="{{ old('ceo_name') }}" placeholder="John Doe" />
                                        <x-input-error :messages="$errors->get('ceo_name')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="revenue_range" :value="__('Annual Revenue Range (Optional)')" />
                                        <select id="revenue_range" name="revenue_range" class="mt-1 block w-full border-gray-300 rounded-md">
                                            <option value="">Select revenue range</option>
                                            <option value="<1M" {{ old('revenue_range') == '<1M' ? 'selected' : '' }}>Less than 1 Million XAF</option>
                                            <option value="1M-10M" {{ old('revenue_range') == '1M-10M' ? 'selected' : '' }}>1-10 Million XAF</option>
                                            <option value="10M-50M" {{ old('revenue_range') == '10M-50M' ? 'selected' : '' }}>10-50 Million XAF</option>
                                            <option value="50M-100M" {{ old('revenue_range') == '50M-100M' ? 'selected' : '' }}>50-100 Million XAF</option>
                                            <option value="100M+" {{ old('revenue_range') == '100M+' ? 'selected' : '' }}>Over 100 Million XAF</option>
                                            <option value="Prefer not to say" {{ old('revenue_range') == 'Prefer not to say' ? 'selected' : '' }}>Prefer not to say</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('revenue_range')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="business_model" :value="__('Business Model')" />
                                        <select id="business_model" name="business_model" class="mt-1 block w-full border-gray-300 rounded-md">
                                            <option value="">Select business model</option>
                                            <option value="B2B" {{ old('business_model') == 'B2B' ? 'selected' : '' }}>Business to Business (B2B)</option>
                                            <option value="B2C" {{ old('business_model') == 'B2C' ? 'selected' : '' }}>Business to Consumer (B2C)</option>
                                            <option value="B2G" {{ old('business_model') == 'B2G' ? 'selected' : '' }}>Business to Government (B2G)</option>
                                            <option value="Mixed" {{ old('business_model') == 'Mixed' ? 'selected' : '' }}>Mixed (Multiple segments)</option>
                                            <option value="Marketplace" {{ old('business_model') == 'Marketplace' ? 'selected' : '' }}>Marketplace Platform</option>
                                            <option value="Subscription" {{ old('business_model') == 'Subscription' ? 'selected' : '' }}>Subscription Based</option>
                                            <option value="Franchise" {{ old('business_model') == 'Franchise' ? 'selected' : '' }}>Franchise Model</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('business_model')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="location" :value="__('Primary Company Location')" />
                                        <x-text-input id="location" name="location" type="text" class="mt-1 block w-full" value="{{ old('location') }}" placeholder="Douala, Littoral Region, Cameroon" />
                                        <x-input-error :messages="$errors->get('location')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="target_market" :value="__('Target Market & Geographic Focus')" />
                                        <textarea id="target_market" name="target_market" rows="3" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Describe your target market, geographic focus, and customer base...">{{ old('target_market') }}</textarea>
                                        <x-input-error :messages="$errors->get('target_market')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="industry_experience" :value="__('Years of Industry Experience')" />
                                        <x-text-input id="industry_experience" name="industry_experience" type="number" class="mt-1 block w-full" value="{{ old('industry_experience') }}" min="0" max="100" placeholder="5" />
                                        <x-input-error :messages="$errors->get('industry_experience')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Step 3: Contact & Social Media Information -->
                        <div class="form-step hidden" data-step="3">
                            <div class="mb-6">
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Step 3: Contact & Social Media Information</h3>
                                <p class="text-gray-600">Help candidates and partners reach you through various channels.</p>
                            </div>
                            
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <x-input-label for="contact_person" :value="__('Primary Contact Person')" />
                                        <x-text-input id="contact_person" name="contact_person" type="text" class="mt-1 block w-full" value="{{ old('contact_person') }}" placeholder="Jane Smith - HR Manager" />
                                        <x-input-error :messages="$errors->get('contact_person')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="contact_email" :value="__('Contact Email')" />
                                        <x-text-input id="contact_email" name="contact_email" type="email" class="mt-1 block w-full" value="{{ old('contact_email') }}" placeholder="contact@yourcompany.com" />
                                        <x-input-error :messages="$errors->get('contact_email')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="contact_phone" :value="__('Contact Phone Number')" />
                                        <x-text-input id="contact_phone" name="contact_phone" type="tel" class="mt-1 block w-full" value="{{ old('contact_phone') }}" placeholder="+237 6XX XXX XXX" />
                                        <x-input-error :messages="$errors->get('contact_phone')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="linkedin_url" :value="__('LinkedIn Company Page')" />
                                        <x-text-input id="linkedin_url" name="linkedin_url" type="url" class="mt-1 block w-full" value="{{ old('linkedin_url') }}" placeholder="https://linkedin.com/company/yourcompany" />
                                        <x-input-error :messages="$errors->get('linkedin_url')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="facebook_url" :value="__('Facebook Page')" />
                                        <x-text-input id="facebook_url" name="facebook_url" type="url" class="mt-1 block w-full" value="{{ old('facebook_url') }}" placeholder="https://facebook.com/yourcompany" />
                                        <x-input-error :messages="$errors->get('facebook_url')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="twitter_url" :value="__('Twitter/X Profile')" />
                                        <x-text-input id="twitter_url" name="twitter_url" type="url" class="mt-1 block w-full" value="{{ old('twitter_url') }}" placeholder="https://twitter.com/yourcompany" />
                                        <x-input-error :messages="$errors->get('twitter_url')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="instagram_url" :value="__('Instagram Profile')" />
                                        <x-text-input id="instagram_url" name="instagram_url" type="url" class="mt-1 block w-full" value="{{ old('instagram_url') }}" placeholder="https://instagram.com/yourcompany" />
                                        <x-input-error :messages="$errors->get('instagram_url')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="domain" :value="__('Custom Career Portal Domain (Optional)')" />
                                        <x-text-input id="domain" name="domain" type="text" class="mt-1 block w-full" value="{{ old('domain') }}" placeholder="jobs.yourcompany.com" />
                                        <x-input-error :messages="$errors->get('domain')" class="mt-2" />
                                        <p class="text-sm text-gray-500 mt-1">Create a branded subdomain for your job portal</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Step 4: Company Culture & Benefits -->
                        <div class="form-step hidden" data-step="4">
                            <div class="mb-6">
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Step 4: Company Culture & Benefits</h3>
                                <p class="text-gray-600">Showcase what makes your company a great place to work.</p>
                            </div>
                            
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="md:col-span-2">
                                        <x-input-label for="company_values" :value="__('Company Values & Culture')" />
                                        <textarea id="company_values" name="company_values" rows="4" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="What are your core values? What kind of culture do you foster? What makes your workplace unique?">{{ old('company_values') }}</textarea>
                                        <x-input-error :messages="$errors->get('company_values')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="benefits_offered" :value="__('Employee Benefits & Perks')" />
                                        <textarea id="benefits_offered" name="benefits_offered" rows="4" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Health insurance, retirement plans, flexible working, training opportunities, bonuses, etc.">{{ old('benefits_offered') }}</textarea>
                                        <x-input-error :messages="$errors->get('benefits_offered')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="career_development" :value="__('Career Development Opportunities')" />
                                        <textarea id="career_development" name="career_development" rows="3" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Training programs, mentorship, advancement opportunities, skill development initiatives...">{{ old('career_development') }}</textarea>
                                        <x-input-error :messages="$errors->get('career_development')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="achievements" :value="__('Company Achievements & Recognition')" />
                                        <textarea id="achievements" name="achievements" rows="3" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Awards, certifications, industry recognition, notable projects, growth milestones...">{{ old('achievements') }}</textarea>
                                        <x-input-error :messages="$errors->get('achievements')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="certifications" :value="__('Industry Certifications & Standards')" />
                                        <textarea id="certifications" name="certifications" rows="2" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="ISO certifications, industry standards compliance, quality certifications...">{{ old('certifications') }}</textarea>
                                        <x-input-error :messages="$errors->get('certifications')" class="mt-2" />
                                    </div>

                                    <div class="md:col-span-2">
                                        <x-input-label for="partnerships" :value="__('Key Partnerships & Collaborations')" />
                                        <textarea id="partnerships" name="partnerships" rows="2" class="mt-1 block w-full border-gray-300 rounded-md" placeholder="Notable partnerships, client relationships, strategic alliances...">{{ old('partnerships') }}</textarea>
                                        <x-input-error :messages="$errors->get('partnerships')" class="mt-2" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Step 5: Brand Customization & Complete -->
                        <div class="form-step hidden" data-step="5">
                            <div class="mb-6">
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Step 5: Brand Customization & Complete Setup</h3>
                                <p class="text-gray-600">Customize your company branding and finalize your profile.</p>
                            </div>
                            
                            <div class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="md:col-span-2">
                                        <x-input-label for="logo_path" :value="__('Company Logo')" />
                                        <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md">
                                            <div class="space-y-1 text-center">
                                                <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                                    <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                                <div class="flex text-sm text-gray-600">
                                                    <label for="logo_path" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                                        <span>Upload a file</span>
                                                        <input id="logo_path" name="logo_path" type="file" class="sr-only" accept="image/*" />
                                                    </label>
                                                    <p class="pl-1">or drag and drop</p>
                                                </div>
                                                <p class="text-xs text-gray-500">PNG, JPG, GIF up to 2MB</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div>
                                        <x-input-label for="color_primary" :value="__('Brand Primary Color')" />
                                        <div class="flex items-center space-x-3">
                                            <input type="color" id="color_primary" name="color_primary" value="{{ old('color_primary', '#3B82F6') }}" class="w-16 h-10 border border-gray-300 rounded-md" />
                                            <x-text-input name="color_primary" value="{{ old('color_primary', '#3B82F6') }}" class="flex-1" placeholder="#3B82F6" />
                                        </div>
                                        <x-input-error :messages="$errors->get('color_primary')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="color_secondary" :value="__('Brand Secondary Color')" />
                                        <div class="flex items-center space-x-3">
                                            <input type="color" id="color_secondary" name="color_secondary" value="{{ old('color_secondary', '#10B981') }}" class="w-16 h-10 border border-gray-300 rounded-md" />
                                            <x-text-input name="color_secondary" value="{{ old('color_secondary', '#10B981') }}" class="flex-1" placeholder="#10B981" />
                                        </div>
                                        <x-input-error :messages="$errors->get('color_secondary')" class="mt-2" />
                                    </div>
                                </div>

                                <!-- Success Benefits -->
                                <div class="bg-gradient-to-r from-green-50 to-blue-50 border border-green-200 rounded-xl p-6">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0">
                                            <svg class="h-8 w-8 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                        </div>
                                        <div class="ml-4">
                                            <h3 class="text-lg font-bold text-green-800 mb-3">🎉 You're Almost Done!</h3>
                                            <div class="text-sm text-green-700 space-y-2">
                                                <p><strong>After completing your company profile, you'll be able to:</strong></p>
                                                <ul class="list-disc list-inside space-y-1 ml-2">
                                                    <li>Post unlimited job listings immediately</li>
                                                    <li>Review and manage applications with our advanced ATS</li>
                                                    <li>Access detailed company analytics and reporting</li>
                                                    <li>Manage your team settings and permissions</li>
                                                    <li>Customize your company brand and appearance</li>
                                                    <li>Connect with qualified candidates in Cameroon</li>
                                                    <li>Use automated screening and interview tools</li>
                                                    <li>Access premium features and priority support</li>
                                                </ul>
                                                <p class="font-medium mt-3">Ready to start hiring top talent in Cameroon? Click complete below!</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Navigation Buttons -->
                        <div class="flex justify-between items-center mt-8 pt-6 border-t border-gray-200">
                            <button type="button" id="prevBtn" onclick="changeStep(-1)" class="hidden hc-btn-secondary flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                                </svg>
                                Previous
                            </button>
                            
                            <button type="button" onclick="window.history.back()" class="hc-btn-secondary">
                                Cancel
                            </button>

                            <button type="button" id="nextBtn" onclick="changeStep(1)" class="hc-btn-primary flex items-center">
                                Next
                                <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                </svg>
                            </button>

                            <button type="submit" id="submitBtn" class="hidden hc-btn-primary flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                                Complete Company Registration
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <style>
        .step-circle {
            transition: all 0.3s ease;
            border: 2px solid #d1d5db;
            background-color: #f9fafb;
            color: #6b7280;
        }
        
        .step-active {
            border-color: #3b82f6;
            background-color: #3b82f6;
            color: white;
        }
        
        .step-inactive {
            border-color: #d1d5db;
            background-color: #f9fafb;
            color: #6b7280;
        }
        
        .step-label-active {
            color: #3b82f6;
            font-weight: 600;
        }
        
        .step-label-inactive {
            color: #6b7280;
            font-weight: 400;
        }
        
        .step-line {
            transition: all 0.3s ease;
        }
    </style>

    <script>
        let currentStep = 1;
        const totalSteps = 5;

        function changeStep(direction) {
            const nextStep = currentStep + direction;
            
            if (nextStep < 1 || nextStep > totalSteps) return;
            
            // Hide current step
            document.querySelector(`[data-step="${currentStep}"]`).classList.add('hidden');
            document.querySelector(`.step-circle[data-step="${currentStep}"]`).classList.remove('step-active');
            document.querySelector(`.step-circle[data-step="${currentStep}"]`).classList.add('step-inactive');
            document.querySelector(`.step-label-active[data-step="${currentStep}"]`)?.classList.remove('step-label-active');
            document.querySelector(`.step-label-active[data-step="${currentStep}"]`)?.classList.add('step-label-inactive');
            
            // Show next step
            document.querySelector(`[data-step="${nextStep}"]`).classList.remove('hidden');
            document.querySelector(`.step-circle[data-step="${nextStep}"]`).classList.remove('step-inactive');
            document.querySelector(`.step-circle[data-step="${nextStep}"]`).classList.add('step-active');
            document.querySelector(`.step-label-inactive[data-step="${nextStep}"]`)?.classList.remove('step-label-inactive');
            document.querySelector(`.step-label-inactive[data-step="${nextStep}"]`)?.classList.add('step-label-active');
            
            // Update line state
            if (nextStep > 1) {
                document.querySelector(`.step-circle[data-step="${nextStep - 1}"]`).nextElementSibling?.classList.add('bg-blue-600');
            }
            if (currentStep > 1) {
                document.querySelector(`.step-circle[data-step="${currentStep - 1}"]`).nextElementSibling?.classList.remove('bg-blue-600');
            }
            
            currentStep = nextStep;
            
            // Update button states
            updateButtons();
        }

        function updateButtons() {
            const prevBtn = document.getElementById('prevBtn');
            const nextBtn = document.getElementById('nextBtn');
            const submitBtn = document.getElementById('submitBtn');
            
            // Previous button
            if (currentStep === 1) {
                prevBtn.classList.add('hidden');
            } else {
                prevBtn.classList.remove('hidden');
            }
            
            // Next vs Submit button
            if (currentStep === totalSteps) {
                nextBtn.classList.add('hidden');
                submitBtn.classList.remove('hidden');
            } else {
                nextBtn.classList.remove('hidden');
                submitBtn.classList.add('hidden');
            }
        }

        // Form validation before step change
        function validateCurrentStep() {
            const currentStepElement = document.querySelector(`[data-step="${currentStep}"]`);
            const requiredFields = currentStepElement.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('border-red-500');
                    isValid = false;
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            return isValid;
        }

        // Enhanced step change with validation
        const originalChangeStep = changeStep;
        changeStep = function(direction) {
            if (direction === 1 && !validateCurrentStep()) {
                alert('Please fill in all required fields before proceeding.');
                return;
            }
            originalChangeStep(direction);
        };

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            updateButtons();
            
            // Add step labels for styling
            const stepLabels = document.querySelectorAll('.step-label-active, .step-label-inactive');
            stepLabels.forEach((label, index) => {
                label.setAttribute('data-step', index + 1);
            });
        });
    </script>
</x-app-layout>


