<x-layouts.ad-container :position="$position">
    @foreach($ads as $ad)
        <div class="ad-item mb-4" 
             data-ad-id="{{ $ad->id }}"
             data-position="{{ $position }}">
            
            @if($ad->type === 'image')
                <a href="{{ route('ads.click', $ad) }}" 
                   target="_blank" 
                   onclick="recordAdClick({{ $ad->id }})"
                   class="block">
                    <img src="{{ Storage::url($ad->image_path) }}" 
                         alt="{{ $ad->title }}" 
                         class="w-full h-auto rounded-lg shadow-sm">
                </a>
            @elseif($ad->type === 'video')
                <div class="video-container relative">
                    <img src="{{ Storage::url($ad->poster_path) }}" 
                         alt="{{ $ad->title }}"
                         class="w-full h-auto rounded-lg shadow-sm cursor-pointer video-poster"
                         onclick="loadVideo(this, '{{ $ad->video_url }}', {{ $ad->id }})">
                    <div class="play-button absolute inset-0 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white opacity-80" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M6.3 2.841A1.5 1.5 0 004 4.11v11.78a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"/>
                        </svg>
                    </div>
                </div>
            @else
                <a href="{{ route('ads.click', $ad) }}"
                   target="_blank"
                   onclick="recordAdClick({{ $ad->id }})"
                   class="block p-4 bg-white rounded-lg shadow-sm hover:shadow-md transition">
                    <h3 class="font-medium text-lg mb-2">{{ $ad->title }}</h3>
                    <div class="text-gray-600">{!! $ad->body_html !!}</div>
                </a>
            @endif

            @if($ad->title)
                <div class="mt-2 text-sm font-medium">{{ $ad->title }}</div>
            @endif
        </div>
    @endforeach
</x-layouts.ad-container>

@once
@push('scripts')
<script>
function loadVideo(poster, videoUrl, adId) {
    const container = poster.closest('.video-container');
    const videoId = extractVideoId(videoUrl);
    let embedHtml = '';

    if (videoUrl.includes('youtube.com') || videoUrl.includes('youtu.be')) {
        embedHtml = `<iframe width="100%" height="225" src="https://www.youtube.com/embed/${videoId}?autoplay=1" frameborder="0" allowfullscreen></iframe>`;
    } else if (videoUrl.includes('vimeo.com')) {
        embedHtml = `<iframe width="100%" height="225" src="https://player.vimeo.com/video/${videoId}?autoplay=1" frameborder="0" allowfullscreen></iframe>`;
    }

    if (embedHtml) {
        container.innerHTML = embedHtml;
        recordAdClick(adId);
    }
}

function extractVideoId(url) {
    let videoId = '';
    if (url.includes('youtube.com') || url.includes('youtu.be')) {
        if (url.includes('youtu.be/')) {
            videoId = url.split('youtu.be/')[1];
        } else {
            const urlParams = new URLSearchParams(new URL(url).search);
            videoId = urlParams.get('v');
        }
    } else if (url.includes('vimeo.com')) {
        videoId = url.split('vimeo.com/')[1];
    }
    return videoId;
}

function recordAdClick(adId) {
    fetch(`/ads/${adId}/click`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    });
}

// Record impressions when ads become visible
document.addEventListener('DOMContentLoaded', function() {
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const adId = entry.target.dataset.adId;
                const position = entry.target.dataset.position;
                
                fetch(`/ads/${adId}/impression`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ position })
                });
                
                // Stop observing after recording impression
                observer.unobserve(entry.target);
            }
        });
    });

    // Start observing all ad items
    document.querySelectorAll('.ad-item').forEach(ad => observer.observe(ad));
});
</script>
@endpush
@endonce