<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="w-10 h-10 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                </div>
                <div>
                    <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                        Post New Job
                    </h2>
                    <p class="text-sm text-gray-600">Create a compelling job listing to attract top talent</p>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <a href="{{ route('dashboard.jobs.index') }}" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg font-medium transition flex items-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                    </svg>
                    Back to Jobs
                </a>
            </div>
        </div>
    </x-slot>

    <form method="POST" action="{{ route('dashboard.jobs.store') }}" class="space-y-8">
        @csrf

        <!-- Job Title & Basic Info -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Job Details</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Job Title -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Job Title *</label>
                    <input type="text" name="title" value="{{ old('title') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 @error('title') border-red-500 @enderror"
                           placeholder="e.g. Senior Software Developer">
                    @error('title')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Location -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Location *</label>
                    <input type="text" name="location" value="{{ old('location') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-green-500/20 focus:border-green-500 transition-all duration-300 @error('location') border-red-500 @enderror"
                           placeholder="e.g. Douala, Cameroon">
                    @error('location')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Employment Type -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Employment Type *</label>
                    <select name="employment_type" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 @error('employment_type') border-red-500 @enderror">
                        <option value="">Select employment type</option>
                        <option value="full-time" {{ old('employment_type') == 'full-time' ? 'selected' : '' }}>Full-time</option>
                        <option value="part-time" {{ old('employment_type') == 'part-time' ? 'selected' : '' }}>Part-time</option>
                        <option value="contract" {{ old('employment_type') == 'contract' ? 'selected' : '' }}>Contract</option>
                        <option value="freelance" {{ old('employment_type') == 'freelance' ? 'selected' : '' }}>Freelance</option>
                        <option value="internship" {{ old('employment_type') == 'internship' ? 'selected' : '' }}>Internship</option>
                    </select>
                    @error('employment_type')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Experience Level -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Experience Level *</label>
                    <select name="experience_level" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300 @error('experience_level') border-red-500 @enderror">
                        <option value="">Select experience level</option>
                        <option value="entry" {{ old('experience_level') == 'entry' ? 'selected' : '' }}>Entry Level (0-2 years)</option>
                        <option value="mid" {{ old('experience_level') == 'mid' ? 'selected' : '' }}>Mid Level (3-5 years)</option>
                        <option value="senior" {{ old('experience_level') == 'senior' ? 'selected' : '' }}>Senior Level (5+ years)</option>
                        <option value="executive" {{ old('experience_level') == 'executive' ? 'selected' : '' }}>Executive Level</option>
                    </select>
                    @error('experience_level')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Application Deadline -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Application Deadline</label>
                    <input type="date" name="application_deadline" value="{{ old('application_deadline') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-orange-500/20 focus:border-orange-500 transition-all duration-300 @error('application_deadline') border-red-500 @enderror">
                    @error('application_deadline')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Job Description -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Job Description</h3>
            </div>

            <div class="space-y-6">
                <!-- Description -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Job Description *</label>
                    <textarea name="description" rows="6"
                              class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 @error('description') border-red-500 @enderror"
                              placeholder="Describe the role, responsibilities, and what the candidate will be doing...">{{ old('description') }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Requirements -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Requirements</label>
                    <textarea name="requirements" rows="4"
                              class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-green-500/20 focus:border-green-500 transition-all duration-300"
                              placeholder="List the required skills, qualifications, and experience...">{{ old('requirements') }}</textarea>
                </div>

                <!-- Responsibilities -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Responsibilities</label>
                    <textarea name="responsibilities" rows="4"
                              class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300"
                              placeholder="Outline the key responsibilities and duties...">{{ old('responsibilities') }}</textarea>
                </div>

                <!-- Benefits -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Benefits & Perks</label>
                    <textarea name="benefits" rows="3"
                              class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-indigo-500/20 focus:border-indigo-500 transition-all duration-300"
                              placeholder="List the benefits, perks, and what makes this role attractive...">{{ old('benefits') }}</textarea>
                </div>
            </div>
        </div>

        <!-- Compensation & Skills -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex items-center mb-6">
                <div class="w-8 h-8 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-black">Compensation & Skills</h3>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Min Salary -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Minimum Salary (XAF)</label>
                    <input type="number" name="salary_min" value="{{ old('salary_min') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-green-500/20 focus:border-green-500 transition-all duration-300 @error('salary_min') border-red-500 @enderror"
                           placeholder="e.g. 50000">
                    @error('salary_min')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Max Salary -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">Maximum Salary (XAF)</label>
                    <input type="number" name="salary_max" value="{{ old('salary_max') }}"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-green-500/20 focus:border-green-500 transition-all duration-300 @error('salary_max') border-red-500 @enderror"
                           placeholder="e.g. 200000">
                    @error('salary_max')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Featured Job -->
                <div class="flex items-center">
                    <input type="checkbox" id="featured" name="featured" value="1" {{ old('featured') ? 'checked' : '' }}
                           class="w-5 h-5 rounded border-2 border-gray-300 text-yellow-600 focus:ring-yellow-500 focus:ring-2 transition-all duration-200">
                    <label for="featured" class="ml-3 text-gray-700 font-medium">Featured Job</label>
                </div>
            </div>

            <!-- Skills -->
            <div class="mt-6">
                <label class="block text-sm font-semibold text-gray-700 mb-3">Required Skills</label>
                <input type="text" name="skills" value="{{ old('skills') }}"
                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300"
                       placeholder="e.g. PHP, Laravel, JavaScript, MySQL (separate with commas)">
                <p class="mt-2 text-sm text-gray-500">Separate multiple skills with commas</p>
            </div>
        </div>

        <!-- Submit Actions -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-8">
            <div class="flex flex-col sm:flex-row gap-4 justify-end">
                <a href="{{ route('dashboard.jobs.index') }}" class="px-6 py-3 border border-gray-300 text-gray-700 rounded-xl hover:bg-gray-50 transition font-medium">
                    Cancel
                </a>
                <button type="submit" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 hover:-translate-y-1 flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                    </svg>
                    Post Job
                </button>
            </div>
        </div>
    </form>
</x-layouts.app>