<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <button onclick="window.history.back()" class="mr-4 p-2 text-gray-400 hover:text-gray-600 transition rounded-lg hover:bg-gray-100">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                    </svg>
                </button>
                <div>
                    <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                        {{ $job->title }}
                    </h2>
                    <p class="text-sm text-gray-600">{{ $job->company->name ?? 'Company Name' }} • {{ $job->location }}</p>
                </div>
            </div>
            <div class="flex gap-3">
                <button class="p-2 text-gray-400 hover:text-red-500 transition rounded-lg hover:bg-red-50">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                    </svg>
                </button>
                <button class="p-2 text-gray-400 hover:text-blue-500 transition rounded-lg hover:bg-blue-50">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.367 2.684 3 3 0 00-5.367-2.684z"/>
                    </svg>
                </button>
            </div>
        </div>
    </x-slot>

    <div class="grid lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Job Header Card -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <!-- Company Image Header -->
                <div class="relative h-64 bg-gradient-to-br from-yellow-400/10 via-yellow-500/10 to-orange-500/10 flex items-center justify-center">
                    @if($job->company && $job->company->logo)
                        <img src="{{ asset('storage/' . $job->company->logo) }}" alt="{{ $job->company->name }}" class="w-32 h-32 rounded-3xl object-cover shadow-2xl border-4 border-white">
                    @else
                        <div class="w-32 h-32 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-3xl flex items-center justify-center shadow-2xl border-4 border-white">
                            <span class="text-black font-black text-4xl">{{ substr($job->company->name ?? 'C', 0, 1) }}</span>
                        </div>
                    @endif

                    @if($job->featured)
                    <div class="absolute top-4 right-4 bg-gradient-to-r from-yellow-400 to-yellow-500 text-black px-4 py-2 rounded-full text-sm font-bold shadow-lg">
                        ⭐ FEATURED
                    </div>
                    @endif
                </div>

                <!-- Job Info Section -->
                <div class="p-8">
                    <div class="text-center mb-6">
                        <h1 class="text-3xl font-black text-black mb-3">{{ $job->title }}</h1>
                        <p class="text-xl text-gray-600 font-medium">{{ $job->company->name ?? 'Company Name' }}</p>

                        <!-- Job Meta -->
                        <div class="flex flex-wrap items-center justify-center gap-4 mt-4 text-sm text-gray-500">
                            <div class="flex items-center bg-yellow-400/10 text-yellow-600 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                {{ $job->location }}
                            </div>
                            <div class="flex items-center bg-yellow-400/10 text-yellow-600 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Posted {{ $job->created_at->diffForHumans() }}
                            </div>
                            <div class="flex items-center bg-yellow-400/10 text-yellow-600 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                                </svg>
                                {{ $job->employment_type ?? 'Full-time' }}
                            </div>
                        </div>
                    </div>

                    <!-- Salary Display -->
                    <div class="text-center mb-6">
                        <div class="text-4xl font-black text-black mb-2">
                            XAF {{ number_format($job->salary_max ?? $job->salary_min ?? 0) }}
                        </div>
                        <div class="text-gray-500">per month</div>
                        @if($job->salary_min && $job->salary_max && $job->salary_min !== $job->salary_max)
                        <div class="text-sm text-gray-400 mt-1">
                            Range: XAF {{ number_format($job->salary_min) }} - {{ number_format($job->salary_max) }}
                        </div>
                        @endif
                    </div>

                    <!-- Quick Stats -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                        <div class="bg-gradient-to-br from-yellow-400/10 to-yellow-400/5 rounded-xl p-4 text-center border border-yellow-400/20">
                            <div class="text-2xl font-bold text-yellow-600 mb-1">{{ $job->applications_count ?? 0 }}</div>
                            <div class="text-gray-600 text-sm">Applicants</div>
                        </div>
                        <div class="bg-gradient-to-br from-yellow-400/10 to-yellow-400/5 rounded-xl p-4 text-center border border-yellow-400/20">
                            <div class="text-2xl font-bold text-yellow-600 mb-1">{{ $job->views_count ?? 0 }}</div>
                            <div class="text-gray-600 text-sm">Views</div>
                        </div>
                        <div class="bg-gradient-to-br from-yellow-400/10 to-yellow-400/5 rounded-xl p-4 text-center border border-yellow-400/20">
                            <div class="text-2xl font-bold text-yellow-600 mb-1">{{ $job->employment_type ?? 'Full-time' }}</div>
                            <div class="text-gray-600 text-sm">Type</div>
                        </div>
                        <div class="bg-gradient-to-br from-yellow-400/10 to-yellow-400/5 rounded-xl p-4 text-center border border-yellow-400/20">
                            <div class="text-2xl font-bold text-yellow-600 mb-1">{{ $job->experience_level ?? 'Mid-level' }}</div>
                            <div class="text-gray-600 text-sm">Level</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Job Description -->
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-black mb-6">Job Description</h2>
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($job->description)) !!}
                </div>
            </div>

            <!-- Requirements -->
            @if($job->requirements)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-black mb-6">Requirements</h2>
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($job->requirements)) !!}
                </div>
            </div>
            @endif

            <!-- Responsibilities -->
            @if($job->responsibilities)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-black mb-6">Key Responsibilities</h2>
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($job->responsibilities)) !!}
                </div>
            </div>
            @endif

            <!-- Benefits -->
            @if($job->benefits)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-black mb-6">What We Offer</h2>
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($job->benefits)) !!}
                </div>
            </div>
            @endif

            <!-- Skills -->
            @if($job->skills)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-black mb-6">Required Skills</h2>
                <div class="flex flex-wrap gap-3">
                    @foreach(explode(',', $job->skills) as $skill)
                    <span class="px-4 py-2 bg-gradient-to-r from-yellow-400 to-yellow-500 text-black text-sm rounded-full font-semibold shadow-md hover:shadow-lg transition-shadow cursor-pointer">
                        {{ trim($skill) }}
                    </span>
                    @endforeach
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Apply Card -->
            <div class="bg-gradient-to-br from-yellow-400 via-yellow-500 to-orange-500 rounded-2xl shadow-2xl p-8 text-center relative overflow-hidden">
                <!-- Background Pattern -->
                <div class="absolute inset-0 bg-white/10 rounded-2xl"></div>
                <div class="relative">
                    <h3 class="text-2xl font-black text-black mb-4">Ready to Apply?</h3>
                    <p class="text-black/80 mb-6">Join the queue of talented candidates applying for this position.</p>

                    @auth
                        @if(!auth()->user()->hasAppliedToJob($job))
                        <form method="POST" action="{{ route('applications.store') }}" enctype="multipart/form-data" class="space-y-4">
                            @csrf
                            <input type="hidden" name="job_id" value="{{ $job->id }}">

                            <!-- Cover Letter Input -->
                            <div class="text-left">
                                <label class="block text-sm font-semibold text-black mb-2 flex items-center">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                    </svg>
                                    Cover Letter (Optional)
                                </label>
                                <textarea name="cover_letter" rows="4" placeholder="Tell us why you're interested in this position and what makes you a great fit..."
                                          class="w-full px-4 py-3 bg-white/90 border-2 border-white/50 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-black/20 focus:bg-white transition-all duration-300 resize-none text-sm"></textarea>
                            </div>

                            <!-- Resume Upload -->
                            <div class="text-left">
                                <label class="block text-sm font-semibold text-black mb-2 flex items-center">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                    </svg>
                                    Resume/CV
                                </label>
                                <div class="relative">
                                    <input type="file" name="resume" accept=".pdf,.doc,.docx,.txt"
                                           class="w-full px-4 py-3 bg-white/90 border-2 border-white/50 rounded-xl text-gray-900 focus:outline-none focus:ring-2 focus:ring-black/20 focus:bg-white transition-all duration-300 file:mr-4 file:py-2 file:px-4 file:rounded-l-xl file:border-0 file:text-sm file:font-semibold file:bg-gray-100 file:text-gray-700 hover:file:bg-gray-200 text-sm">
                                </div>
                                <p class="text-xs text-black/60 mt-1">Accepted formats: PDF, DOC, DOCX, TXT (Max 5MB)</p>
                            </div>

                            <button type="submit" class="w-full bg-black hover:bg-gray-800 text-white font-bold py-4 px-6 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center justify-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                </svg>
                                Submit Application
                            </button>
                        </form>
                        @else
                        <div class="bg-black/20 text-black font-bold py-4 px-6 rounded-xl flex items-center justify-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Already Applied
                        </div>
                        @endif
                    @else
                    <a href="{{ route('login') }}" class="w-full bg-black hover:bg-gray-800 text-white font-bold py-4 px-6 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 inline-block flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
                        </svg>
                        Login to Apply
                    </a>
                    @endauth

                    <div class="mt-4 text-sm text-black/60">
                        Application deadline: {{ $job->application_deadline ? $job->application_deadline->format('M j, Y') : 'Open until filled' }}
                    </div>
                </div>
            </div>

            <!-- Company Info -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-black">About the Company</h3>
                    @if($job->company)
                    <a href="{{ route('companies.show', $job->company) }}" class="text-yellow-600 hover:text-yellow-800 text-sm font-medium flex items-center">
                        View Full Profile
                        <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                        </svg>
                    </a>
                    @endif
                </div>

                <div class="flex items-center mb-4">
                    @if($job->company && $job->company->logo)
                        <img src="{{ asset('storage/' . $job->company->logo) }}" alt="{{ $job->company->name }}" class="w-16 h-16 rounded-2xl object-cover mr-4 shadow-lg">
                    @else
                        <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-2xl flex items-center justify-center mr-4 shadow-lg">
                            <span class="text-black font-bold text-xl">{{ substr($job->company->name ?? 'C', 0, 1) }}</span>
                        </div>
                    @endif
                    <div>
                        <h4 class="font-bold text-black text-lg">{{ $job->company->name ?? 'Company Name' }}</h4>
                        <p class="text-gray-600 text-sm">{{ $job->company->industry ?? 'Industry' }}</p>
                    </div>
                </div>

                @if($job->company)
                <p class="text-gray-700 text-sm mb-6 leading-relaxed">{{ $job->company->description ?? 'A leading company in Cameroon.' }}</p>

                <div class="grid grid-cols-2 gap-4 mb-6">
                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-4 rounded-xl">
                        <div class="text-blue-600 text-sm font-medium mb-1">Industry</div>
                        <div class="text-black font-bold">{{ $job->company->industry ?? 'N/A' }}</div>
                    </div>
                    <div class="bg-gradient-to-br from-green-50 to-green-100 p-4 rounded-xl">
                        <div class="text-green-600 text-sm font-medium mb-1">Company Size</div>
                        <div class="text-black font-bold">{{ $job->company->size ?? 'N/A' }}</div>
                    </div>
                    <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-4 rounded-xl">
                        <div class="text-purple-600 text-sm font-medium mb-1">Founded</div>
                        <div class="text-black font-bold">{{ $job->company->founded_year ?? 'N/A' }}</div>
                    </div>
                    <div class="bg-gradient-to-br from-orange-50 to-orange-100 p-4 rounded-xl">
                        <div class="text-orange-600 text-sm font-medium mb-1">Location</div>
                        <div class="text-black font-bold">{{ $job->company->location ?? 'Cameroon' }}</div>
                    </div>
                </div>

                <!-- Job Poster Information -->
                @if($job->company && $job->company->owner)
                <div class="border-t border-gray-100 pt-6">
                    <h4 class="text-lg font-bold text-black mb-4">Posted By</h4>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-xl flex items-center justify-center mr-4">
                            <span class="text-black font-bold">{{ substr($job->company->owner->name, 0, 1) }}</span>
                        </div>
                        <div>
                            <h5 class="font-bold text-black">{{ $job->company->owner->name }}</h5>
                            <p class="text-gray-600 text-sm">{{ $job->company->owner->profile->current_job_title ?? 'HR Manager' }} at {{ $job->company->name }}</p>
                            <p class="text-gray-500 text-xs">Posted {{ $job->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                </div>
                @endif
                @endif
            </div>

            <!-- Job Details -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h3 class="text-xl font-bold text-black mb-4">Job Details</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                            </svg>
                            Employment Type
                        </span>
                        <span class="font-bold text-black">{{ $job->employment_type ?? 'Full-time' }}</span>
                    </div>

                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                            Experience Level
                        </span>
                        <span class="font-bold text-black">{{ $job->experience_level ?? 'Mid-level' }}</span>
                    </div>

                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            Location
                        </span>
                        <span class="font-bold text-black">{{ $job->location }}</span>
                    </div>

                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                            </svg>
                            Salary Range
                        </span>
                        <span class="font-bold text-black">
                            XAF {{ number_format($job->salary_min ?? 0) }} - {{ number_format($job->salary_max ?? 0) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Similar Jobs -->
            @if(isset($similarJobs) && $similarJobs->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h3 class="text-xl font-bold text-black mb-4">Similar Jobs</h3>
                <div class="space-y-4">
                    @foreach($similarJobs->take(3) as $similarJob)
                    <a href="{{ route('jobs.show', $similarJob) }}" class="block p-4 bg-gray-50 rounded-xl hover:bg-gray-100 transition">
                        <h4 class="font-bold text-black mb-1">{{ $similarJob->title }}</h4>
                        <p class="text-gray-600 text-sm">{{ $similarJob->company->name ?? 'Company' }} • {{ $similarJob->location }}</p>
                        <p class="text-yellow-600 font-bold text-sm">XAF {{ number_format($similarJob->salary_max ?? 0) }}</p>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-layouts.app>