<x-layouts.app>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Profile Settings') }}
        </h2>
    </x-slot>

    <!-- Profile Header -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden mb-8">
        <div class="bg-gradient-to-br from-brand-blue via-brand-purple to-brand-cyan text-white p-8 relative">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-black/10 rounded-2xl"></div>
            <div class="relative flex items-center">
                @if(auth()->user()->profile && auth()->user()->profile->avatar)
                    <img src="{{ asset('storage/' . auth()->user()->profile->avatar) }}" alt="{{ auth()->user()->name }}" class="w-24 h-24 rounded-3xl object-cover mr-6 shadow-2xl border-4 border-white">
                @else
                    <div class="w-24 h-24 bg-gradient-to-br from-white/20 to-white/10 backdrop-blur-sm rounded-3xl flex items-center justify-center mr-6 shadow-2xl border-4 border-white/50">
                        <span class="text-white font-black text-3xl">{{ substr(auth()->user()->name ?? 'U', 0, 1) }}</span>
                    </div>
                @endif
                <div class="flex-1">
                    <h1 class="text-3xl font-black">{{ auth()->user()->name }}</h1>
                    <p class="text-white/80 text-lg">{{ auth()->user()->email }}</p>
                    <div class="flex items-center gap-4 mt-3">
                        @if(auth()->user()->isCompany())
                        <span class="px-4 py-2 bg-white/20 backdrop-blur-sm text-white rounded-full text-sm font-bold border border-white/30">
                            Company Account
                        </span>
                        @else
                        <span class="px-4 py-2 bg-white/20 backdrop-blur-sm text-white rounded-full text-sm font-bold border border-white/30">
                            Job Seeker
                        </span>
                        @endif
                        @if(auth()->user()->profile)
                        <span class="px-4 py-2 bg-white/20 backdrop-blur-sm text-white rounded-full text-sm font-bold border border-white/30">
                            {{ auth()->user()->profile->current_job_title ?? 'Professional' }}
                        </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Profile Completion & Stats -->
        <div class="p-8 border-t border-gray-100">
            <div class="grid md:grid-cols-2 gap-8">
                <!-- Profile Completion -->
                <div>
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-black">Profile Completion</h3>
                        <span class="text-2xl font-black text-brand-blue">85%</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-4 mb-4">
                        <div class="bg-gradient-to-r from-brand-blue to-brand-purple h-4 rounded-full transition-all duration-500" style="width: 85%"></div>
                    </div>
                    <p class="text-gray-600 text-sm">Complete your profile to increase your chances of getting hired</p>
                </div>

                <!-- Quick Stats -->
                <div class="grid grid-cols-2 gap-4">
                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl p-4 text-center border border-blue-200">
                        <div class="text-2xl font-bold text-blue-600 mb-1">{{ auth()->user()->applications->count() }}</div>
                        <div class="text-gray-600 text-sm">Applications</div>
                    </div>
                    <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-4 text-center border border-green-200">
                        <div class="text-2xl font-bold text-green-600 mb-1">{{ auth()->user()->profile ? auth()->user()->profile->skills ? count(explode(',', auth()->user()->profile->skills)) : 0 : 0 }}</div>
                        <div class="text-gray-600 text-sm">Skills</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Profile Tabs -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
        <!-- Tab Navigation -->
        <div class="border-b border-gray-200 bg-gray-50">
            <nav class="flex">
                <button onclick="showTab('personal')" class="tab-button active px-8 py-4 text-black font-bold border-b-2 border-brand-blue bg-white rounded-t-xl">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Personal Info
                </button>
                @if(auth()->user()->isCompany())
                <button onclick="showTab('company')" class="tab-button px-8 py-4 text-gray-600 font-medium hover:text-black transition rounded-t-xl hover:bg-white">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    Company
                </button>
                @else
                <button onclick="showTab('professional')" class="tab-button px-8 py-4 text-gray-600 font-medium hover:text-black transition rounded-t-xl hover:bg-white">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                    </svg>
                    Professional
                </button>
                @endif
                <button onclick="showTab('preferences')" class="tab-button px-8 py-4 text-gray-600 font-medium hover:text-black transition rounded-t-xl hover:bg-white">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    Preferences
                </button>
                <button onclick="showTab('security')" class="tab-button px-8 py-4 text-gray-600 font-medium hover:text-black transition rounded-t-xl hover:bg-white">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                    Security
                </button>
            </nav>
        </div>

        <!-- Tab Content -->
        <div class="p-8">
            <!-- Personal Information Tab -->
            <div id="personal-tab" class="tab-content">
                <div class="mb-6">
                    <h3 class="text-xl font-bold text-black mb-2">Personal Information</h3>
                    <p class="text-gray-600">Update your personal details to help employers find you</p>
                </div>

                <form method="POST" action="{{ route('profile.update') }}" class="space-y-8">
                    @csrf
                    @method('PATCH')

                    <!-- Avatar Upload Section -->
                    <div class="bg-gradient-to-r from-gray-50 to-gray-100 rounded-2xl p-6 border border-gray-200">
                        <h4 class="text-lg font-bold text-black mb-4">Profile Picture</h4>
                        <div class="flex items-center space-x-6">
                            <div class="relative">
                                @if(auth()->user()->profile && auth()->user()->profile->avatar)
                                    <img src="{{ asset('storage/' . auth()->user()->profile->avatar) }}" alt="Profile" class="w-20 h-20 rounded-2xl object-cover shadow-lg">
                                @else
                                    <div class="w-20 h-20 bg-gradient-to-br from-brand-blue to-brand-purple rounded-2xl flex items-center justify-center shadow-lg">
                                        <span class="text-white font-bold text-xl">{{ substr(auth()->user()->name ?? 'U', 0, 1) }}</span>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-1">
                                <label class="block text-sm font-bold text-black mb-2">Upload New Picture</label>
                                <input type="file" name="avatar" accept="image/*" class="w-full px-4 py-3 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-0 transition file:mr-4 file:py-2 file:px-4 file:rounded-l-xl file:border-0 file:text-sm file:font-semibold file:bg-brand-blue file:text-white hover:file:bg-brand-indigo">
                                <p class="text-gray-500 text-sm mt-1">JPG, PNG or GIF. Max size 2MB.</p>
                            </div>
                        </div>
                    </div>

                    <div class="grid md:grid-cols-2 gap-6">
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-black flex items-center">
                                <svg class="w-4 h-4 mr-2 text-brand-blue" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                First Name
                            </label>
                            <input type="text" name="first_name" value="{{ old('first_name', auth()->user()->name ? explode(' ', auth()->user()->name)[0] : '') }}"
                                    class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 placeholder-gray-500 shadow-sm">
                        </div>
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-black flex items-center">
                                <svg class="w-4 h-4 mr-2 text-brand-blue" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                Last Name
                            </label>
                            <input type="text" name="last_name" value="{{ old('last_name', auth()->user()->name ? explode(' ', auth()->user()->name)[1] ?? '' : '') }}"
                                    class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 placeholder-gray-500 shadow-sm">
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="block text-sm font-bold text-black flex items-center">
                            <svg class="w-4 h-4 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            Email Address
                        </label>
                        <input type="email" name="email" value="{{ old('email', auth()->user()->email) }}"
                                class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 placeholder-gray-500 shadow-sm">
                        <p class="text-gray-500 text-sm">This email will be used for job notifications and account recovery</p>
                    </div>

                    <div class="grid md:grid-cols-2 gap-6">
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-black flex items-center">
                                <svg class="w-4 h-4 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                </svg>
                                Phone Number
                            </label>
                            <input type="tel" name="phone" value="{{ old('phone', auth()->user()->profile->phone ?? '') }}"
                                    class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 placeholder-gray-500 shadow-sm"
                                    placeholder="+237 6XX XXX XXX">
                        </div>
                        <div class="space-y-2">
                            <label class="block text-sm font-bold text-black flex items-center">
                                <svg class="w-4 h-4 mr-2 text-pink-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                                Date of Birth
                            </label>
                            <input type="date" name="date_of_birth" value="{{ old('date_of_birth', auth()->user()->profile->date_of_birth ?? '') }}"
                                    class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 shadow-sm">
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="block text-sm font-bold text-black flex items-center">
                            <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            Location
                        </label>
                        <select name="location" class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 shadow-sm appearance-none">
                            <option value="">Select your location</option>
                            <option value="douala" {{ old('location', auth()->user()->profile->location ?? '') == 'douala' ? 'selected' : '' }}>Douala</option>
                            <option value="yaounde" {{ old('location', auth()->user()->profile->location ?? '') == 'yaounde' ? 'selected' : '' }}>Yaoundé</option>
                            <option value="limbe" {{ old('location', auth()->user()->profile->location ?? '') == 'limbe' ? 'selected' : '' }}>Limbé</option>
                            <option value="bafoussam" {{ old('location', auth()->user()->profile->location ?? '') == 'bafoussam' ? 'selected' : '' }}>Bafoussam</option>
                            <option value="bamenda" {{ old('location', auth()->user()->profile->location ?? '') == 'bamenda' ? 'selected' : '' }}>Bamenda</option>
                            <option value="garoua" {{ old('location', auth()->user()->profile->location ?? '') == 'garoua' ? 'selected' : '' }}>Garoua</option>
                            <option value="maroua" {{ old('location', auth()->user()->profile->location ?? '') == 'maroua' ? 'selected' : '' }}>Maroua</option>
                            <option value="ngaoundere" {{ old('location', auth()->user()->profile->location ?? '') == 'ngaoundere' ? 'selected' : '' }}>Ngaoundéré</option>
                        </select>
                    </div>

                    <div class="space-y-2">
                        <label class="block text-sm font-bold text-black flex items-center">
                            <svg class="w-4 h-4 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Bio
                        </label>
                        <textarea name="bio" rows="4" class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl focus:border-brand-blue focus:ring-4 focus:ring-brand-blue/10 transition-all duration-300 text-gray-900 placeholder-gray-500 shadow-sm resize-none"
                                  placeholder="Tell employers about yourself, your career goals, and what makes you unique...">{{ old('bio', auth()->user()->profile->bio ?? '') }}</textarea>
                        <p class="text-gray-500 text-sm">This will be visible to employers when they view your profile</p>
                    </div>

                    <div class="flex gap-4 pt-6">
                        <button type="submit" class="bg-gradient-to-r from-brand-blue to-brand-purple hover:from-brand-indigo hover:to-brand-violet text-white font-bold px-8 py-4 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            Save Personal Info
                        </button>
                        <a href="{{ route('profile.edit') }}" class="px-6 py-4 border-2 border-gray-300 text-gray-700 rounded-xl hover:border-gray-400 transition-all duration-300">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>

            <!-- Professional Tab (Job Seekers) -->
            @if(!auth()->user()->isCompany())
            <div id="professional-tab" class="tab-content hidden">
                <form method="POST" action="{{ route('profile.update-professional') }}" class="space-y-6">
                    @csrf
                    @method('PATCH')

                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Current Job Title</label>
                            <input type="text" name="current_job_title" value="{{ old('current_job_title', auth()->user()->profile->current_job_title ?? '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition"
                                   placeholder="e.g., Software Developer">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Years of Experience</label>
                            <select name="experience_years" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                                <option value="">Select experience</option>
                                <option value="0-1" {{ old('experience_years', auth()->user()->profile->experience_years ?? '') == '0-1' ? 'selected' : '' }}>0-1 years</option>
                                <option value="1-3" {{ old('experience_years', auth()->user()->profile->experience_years ?? '') == '1-3' ? 'selected' : '' }}>1-3 years</option>
                                <option value="3-5" {{ old('experience_years', auth()->user()->profile->experience_years ?? '') == '3-5' ? 'selected' : '' }}>3-5 years</option>
                                <option value="5-10" {{ old('experience_years', auth()->user()->profile->experience_years ?? '') == '5-10' ? 'selected' : '' }}>5-10 years</option>
                                <option value="10+" {{ old('experience_years', auth()->user()->profile->experience_years ?? '') == '10+' ? 'selected' : '' }}>10+ years</option>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Skills</label>
                        <input type="text" name="skills" value="{{ old('skills', auth()->user()->profile->skills ?? '') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition"
                               placeholder="e.g., JavaScript, React, Node.js (separate with commas)">
                        <p class="text-gray-500 text-sm mt-1">Separate skills with commas</p>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Education</label>
                        <select name="education_level" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                            <option value="">Select education level</option>
                            <option value="high_school" {{ old('education_level', auth()->user()->profile->education_level ?? '') == 'high_school' ? 'selected' : '' }}>High School</option>
                            <option value="bachelor" {{ old('education_level', auth()->user()->profile->education_level ?? '') == 'bachelor' ? 'selected' : '' }}>Bachelor's Degree</option>
                            <option value="master" {{ old('education_level', auth()->user()->profile->education_level ?? '') == 'master' ? 'selected' : '' }}>Master's Degree</option>
                            <option value="phd" {{ old('education_level', auth()->user()->profile->education_level ?? '') == 'phd' ? 'selected' : '' }}>PhD</option>
                        </select>
                    </div>

                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Expected Salary (XAF)</label>
                            <input type="number" name="expected_salary" value="{{ old('expected_salary', auth()->user()->profile->expected_salary ?? '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition"
                                   placeholder="e.g., 350000">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Availability</label>
                            <select name="availability" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                                <option value="">Select availability</option>
                                <option value="immediately" {{ old('availability', auth()->user()->profile->availability ?? '') == 'immediately' ? 'selected' : '' }}>Immediately</option>
                                <option value="2_weeks" {{ old('availability', auth()->user()->profile->availability ?? '') == '2_weeks' ? 'selected' : '' }}>2 weeks notice</option>
                                <option value="1_month" {{ old('availability', auth()->user()->profile->availability ?? '') == '1_month' ? 'selected' : '' }}>1 month notice</option>
                                <option value="3_months" {{ old('availability', auth()->user()->profile->availability ?? '') == '3_months' ? 'selected' : '' }}>3 months notice</option>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Resume/CV</label>
                        <div class="border-2 border-dashed border-gray-300 rounded-xl p-6 text-center hover:border-yellow-400 transition">
                            <input type="file" name="resume" accept=".pdf,.doc,.docx"
                                   class="hidden" id="resume-upload">
                            <label for="resume-upload" class="cursor-pointer">
                                <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                                </svg>
                                <p class="text-gray-600 font-medium">Upload your resume</p>
                                <p class="text-gray-400 text-sm mt-1">PDF, DOC, DOCX up to 5MB</p>
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                        Save Professional Info
                    </button>
                </form>
            </div>
            @endif

            <!-- Company Tab (Company Accounts) -->
            @if(auth()->user()->isCompany())
            <div id="company-tab" class="tab-content hidden">
                <form method="POST" action="{{ route('company.update') }}" class="space-y-6">
                    @csrf
                    @method('PATCH')

                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Company Name</label>
                            <input type="text" name="name" value="{{ old('name', auth()->user()->company->name ?? '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition"
                                   placeholder="Your company name">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Industry</label>
                            <select name="industry" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition">
                                <option value="">Select industry</option>
                                <option value="technology" {{ old('industry', auth()->user()->company->industry ?? '') == 'technology' ? 'selected' : '' }}>Technology</option>
                                <option value="finance" {{ old('industry', auth()->user()->company->industry ?? '') == 'finance' ? 'selected' : '' }}>Finance & Banking</option>
                                <option value="healthcare" {{ old('industry', auth()->user()->company->industry ?? '') == 'healthcare' ? 'selected' : '' }}>Healthcare</option>
                                <option value="education" {{ old('industry', auth()->user()->company->industry ?? '') == 'education' ? 'selected' : '' }}>Education</option>
                                <option value="retail" {{ old('industry', auth()->user()->company->industry ?? '') == 'retail' ? 'selected' : '' }}>Retail & Commerce</option>
                                <option value="logistics" {{ old('industry', auth()->user()->company->industry ?? '') == 'logistics' ? 'selected' : '' }}>Logistics</option>
                                <option value="manufacturing" {{ old('industry', auth()->user()->company->industry ?? '') == 'manufacturing' ? 'selected' : '' }}>Manufacturing</option>
                                <option value="construction" {{ old('industry', auth()->user()->company->industry ?? '') == 'construction' ? 'selected' : '' }}>Construction</option>
                                <option value="agriculture" {{ old('industry', auth()->user()->company->industry ?? '') == 'agriculture' ? 'selected' : '' }}>Agriculture</option>
                                <option value="energy" {{ old('industry', auth()->user()->company->industry ?? '') == 'energy' ? 'selected' : '' }}>Energy & Utilities</option>
                                <option value="government" {{ old('industry', auth()->user()->company->industry ?? '') == 'government' ? 'selected' : '' }}>Government</option>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Company Description</label>
                        <textarea name="description" rows="4" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition resize-none"
                                  placeholder="Describe your company, mission, and values...">{{ old('description', auth()->user()->company->description ?? '') }}</textarea>
                        <p class="text-gray-500 text-sm mt-1">This will be visible to job seekers</p>
                    </div>

                    <div class="grid md:grid-cols-3 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Company Size</label>
                            <select name="size" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition">
                                <option value="">Select size</option>
                                <option value="1-10" {{ old('size', auth()->user()->company->size ?? '') == '1-10' ? 'selected' : '' }}>1-10 employees</option>
                                <option value="11-50" {{ old('size', auth()->user()->company->size ?? '') == '11-50' ? 'selected' : '' }}>11-50 employees</option>
                                <option value="51-200" {{ old('size', auth()->user()->company->size ?? '') == '51-200' ? 'selected' : '' }}>51-200 employees</option>
                                <option value="201-500" {{ old('size', auth()->user()->company->size ?? '') == '201-500' ? 'selected' : '' }}>201-500 employees</option>
                                <option value="500+" {{ old('size', auth()->user()->company->size ?? '') == '500+' ? 'selected' : '' }}>500+ employees</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Founded Year</label>
                            <input type="number" name="founded_year" value="{{ old('founded_year', auth()->user()->company->founded_year ?? '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition"
                                   placeholder="e.g., 2020" min="1800" max="{{ date('Y') }}">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Location</label>
                            <select name="location" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition">
                                <option value="">Select location</option>
                                <option value="douala" {{ old('location', auth()->user()->company->location ?? '') == 'douala' ? 'selected' : '' }}>Douala</option>
                                <option value="yaounde" {{ old('location', auth()->user()->company->location ?? '') == 'yaounde' ? 'selected' : '' }}>Yaoundé</option>
                                <option value="limbe" {{ old('location', auth()->user()->company->location ?? '') == 'limbe' ? 'selected' : '' }}>Limbé</option>
                                <option value="bafoussam" {{ old('location', auth()->user()->company->location ?? '') == 'bafoussam' ? 'selected' : '' }}>Bafoussam</option>
                                <option value="bamenda" {{ old('location', auth()->user()->company->location ?? '') == 'bamenda' ? 'selected' : '' }}>Bamenda</option>
                                <option value="garoua" {{ old('location', auth()->user()->company->location ?? '') == 'garoua' ? 'selected' : '' }}>Garoua</option>
                                <option value="maroua" {{ old('location', auth()->user()->company->location ?? '') == 'maroua' ? 'selected' : '' }}>Maroua</option>
                                <option value="ngaoundere" {{ old('location', auth()->user()->company->location ?? '') == 'ngaoundere' ? 'selected' : '' }}>Ngaoundéré</option>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Company Logo</label>
                        <div class="border-2 border-dashed border-gray-300 rounded-xl p-6 text-center hover:border-blue-400 transition">
                            <input type="file" name="logo" accept="image/*"
                                   class="hidden" id="logo-upload">
                            <label for="logo-upload" class="cursor-pointer">
                                <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                                <p class="text-gray-600 font-medium">Upload company logo</p>
                                <p class="text-gray-400 text-sm mt-1">PNG, JPG, GIF up to 2MB</p>
                            </label>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Website</label>
                        <input type="url" name="website" value="{{ old('website', auth()->user()->company->website ?? '') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-blue-400 focus:ring-0 transition"
                               placeholder="https://yourcompany.com">
                    </div>

                    <button type="submit" class="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                        Save Company Info
                    </button>
                </form>
            </div>
            @endif

            <!-- Preferences Tab -->
            <div id="preferences-tab" class="tab-content hidden">
                <form method="POST" action="{{ route('profile.update-preferences') }}" class="space-y-6">
                    @csrf
                    @method('PATCH')

                    <div>
                        <h3 class="text-lg font-bold text-black mb-4">Job Preferences</h3>
                        <div class="space-y-4">
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                                <div>
                                    <h4 class="font-bold text-black">Remote Work</h4>
                                    <p class="text-gray-600 text-sm">Show me remote job opportunities</p>
                                </div>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="remote_preference" value="1" {{ old('remote_preference', true) ? 'checked' : '' }} class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-yellow-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-yellow-400"></div>
                                </label>
                            </div>

                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                                <div>
                                    <h4 class="font-bold text-black">Email Notifications</h4>
                                    <p class="text-gray-600 text-sm">Receive job recommendations via email</p>
                                </div>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="email_notifications" value="1" {{ old('email_notifications', true) ? 'checked' : '' }} class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-yellow-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-yellow-400"></div>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-bold text-black mb-4">Preferred Industries</h3>
                        <div class="grid md:grid-cols-2 gap-3">
                            @foreach(['Technology', 'Finance', 'Healthcare', 'Education', 'Retail', 'Logistics', 'Marketing', 'Consulting'] as $industry)
                            <label class="flex items-center p-3 bg-gray-50 rounded-xl cursor-pointer hover:bg-gray-100 transition">
                                <input type="checkbox" name="preferred_industries[]" value="{{ $industry }}"
                                       {{ in_array($industry, old('preferred_industries', [])) ? 'checked' : '' }}
                                       class="rounded border-gray-300 text-yellow-400 focus:ring-yellow-400">
                                <span class="ml-3 text-black font-medium">{{ $industry }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <button type="submit" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                        Save Preferences
                    </button>
                </form>
            </div>

            <!-- Security Tab -->
            <div id="security-tab" class="tab-content hidden">
                <form method="POST" action="{{ route('profile.password.update') }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div>
                        <h3 class="text-lg font-bold text-black mb-4">Change Password</h3>
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-bold text-black mb-2">Current Password</label>
                                <input type="password" name="current_password"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                            </div>
                            <div>
                                <label class="block text-sm font-bold text-black mb-2">New Password</label>
                                <input type="password" name="password"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                            </div>
                            <div>
                                <label class="block text-sm font-bold text-black mb-2">Confirm New Password</label>
                                <input type="password" name="password_confirmation"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-8 py-3 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                        Update Password
                    </button>
                </form>

                <div class="mt-8 pt-8 border-t border-gray-200">
                    <h3 class="text-lg font-bold text-black mb-4">Account Actions</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-4 bg-red-50 rounded-xl">
                            <div>
                                <h4 class="font-bold text-red-900">Delete Account</h4>
                                <p class="text-red-700 text-sm">Permanently delete your account and all data</p>
                            </div>
                            <button class="px-4 py-2 bg-red-500 text-white rounded-lg hover:bg-red-600 transition">
                                Delete
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>

<script>
function showTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.classList.add('hidden');
    });

    // Remove active class from all buttons
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('active');
        button.classList.remove('border-b-2', 'border-yellow-400', 'border-blue-400');
        button.classList.add('text-gray-600');
    });

    // Show selected tab
    document.getElementById(tabName + '-tab').classList.remove('hidden');

    // Add active class to clicked button with appropriate color
    event.target.classList.add('active', 'border-b-2');
    if (tabName === 'company') {
        event.target.classList.add('border-blue-400');
    } else {
        event.target.classList.add('border-yellow-400');
    }
    event.target.classList.remove('text-gray-600');
}
</script>
