<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Admin\CommunicationController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/

Route::prefix('admin')->name('admin.')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/', [AdminController::class, 'index'])->name('dashboard');
    Route::get('/users', [AdminController::class, 'users'])->name('users');
    Route::get('/jobs', [AdminController::class, 'jobs'])->name('jobs');
    Route::get('/applications', [AdminController::class, 'applications'])->name('applications');
    Route::get('/settings', [AdminController::class, 'settings'])->name('settings');
    Route::get('/analytics', [AdminController::class, 'analytics'])->name('analytics');
    
    // Communication Management Routes
    Route::prefix('communication')->name('communication.')->group(function () {
        Route::get('/', [CommunicationController::class, 'index'])->name('index');
        Route::get('/settings', [CommunicationController::class, 'settings'])->name('settings');
        Route::put('/settings', [CommunicationController::class, 'updateSettings'])->name('settings.update');
        Route::post('/test/email', [CommunicationController::class, 'testEmail'])->name('test.email');
        Route::post('/test/sms', [CommunicationController::class, 'testSms'])->name('test.sms');
        Route::post('/test/message', [CommunicationController::class, 'sendTestMessage'])->name('test.message');
        Route::get('/logs', [CommunicationController::class, 'logs'])->name('logs');
        Route::get('/analytics', [CommunicationController::class, 'analytics'])->name('analytics');
        Route::post('/bulk-send', [CommunicationController::class, 'bulkSend'])->name('bulk-send');
    });
});

// Admin authentication routes (outside auth middleware)
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AdminController::class, 'login'])->name('login');
    Route::post('/login', [AdminController::class, 'authenticate'])->name('authenticate');
    Route::post('/logout', [AdminController::class, 'logout'])->name('logout');
});

// Health check endpoint
Route::get('/health', function () {
    return response()->json([
        'status' => 'healthy',
        'timestamp' => now()->toISOString(),
        'version' => config('app.version', '1.0.0'),
        'environment' => app()->environment(),
    ]);
})->name('health.check');

// API status endpoint
Route::get('/api/status', function () {
    return response()->json([
        'status' => 'operational',
        'timestamp' => now()->toISOString(),
        'services' => [
            'database' => 'ok',
            'cache' => 'ok',
            'queue' => 'ok',
        ]
    ]);
})->name('api.status');