<?php if (isset($component)) { $__componentOriginalc73518e4e557af3c08494b658146df84390e8f3a = $component; } ?>
<?php $component = App\View\Components\Layouts\App::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Layouts\App::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Browse Companies')); ?>

            </h2>
            <a href="/" class="inline-flex items-center text-gray-600 hover:text-yellow-600 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
                Back to Home
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <!-- Hero Section -->
    <div class="bg-gradient-to-br from-yellow-400 via-yellow-500 to-orange-500 text-black">
        <div class="max-w-7xl mx-auto px-8 py-16">
            <div class="text-center">
                <h1 class="text-5xl md:text-6xl font-black mb-6">
                    Discover Top Companies
                </h1>
                <p class="text-xl md:text-2xl text-black/80 max-w-3xl mx-auto mb-8">
                    Explore leading companies in Cameroon and find your next career opportunity.
                </p>
            </div>
        </div>
    </div>

    <!-- Search Section -->
    <div class="bg-white shadow-lg -mt-8 relative z-10 mx-4 sm:mx-8 rounded-2xl border border-gray-100">
        <div class="p-8">
            <div class="max-w-6xl mx-auto">
                <form method="GET" action="<?php echo e(route('companies.index')); ?>" class="space-y-6">
                    <!-- Search Row -->
                    <div class="bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-xl border border-white/50">
                        <div class="grid md:grid-cols-4 gap-6">
                            <div class="md:col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-3 flex items-center">
                                    <svg class="w-4 h-4 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                    </svg>
                                    Company Name
                                </label>
                                <input type="text" name="q" value="<?php echo e(request('q')); ?>"
                                       placeholder="Search companies..."
                                       class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-lg shadow-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-3 flex items-center">
                                    <svg class="w-4 h-4 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                    Location
                                </label>
                                <select name="location" class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-green-500/20 focus:border-green-500 transition-all duration-300 shadow-sm appearance-none">
                                    <option value="">All Locations</option>
                                    <option value="douala" <?php echo e(request('location') == 'douala' ? 'selected' : ''); ?>>Douala</option>
                                    <option value="yaounde" <?php echo e(request('location') == 'yaounde' ? 'selected' : ''); ?>>Yaoundé</option>
                                    <option value="limbe" <?php echo e(request('location') == 'limbe' ? 'selected' : ''); ?>>Limbé</option>
                                    <option value="bafoussam" <?php echo e(request('location') == 'bafoussam' ? 'selected' : ''); ?>>Bafoussam</option>
                                    <option value="bamenda" <?php echo e(request('location') == 'bamenda' ? 'selected' : ''); ?>>Bamenda</option>
                                    <option value="remote" <?php echo e(request('location') == 'remote' ? 'selected' : ''); ?>>Remote</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-3 flex items-center">
                                    <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                    </svg>
                                    Sector
                                </label>
                                <select name="sector" class="w-full px-4 py-4 bg-white border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 shadow-sm appearance-none">
                                    <option value="">All Sectors</option>
                                    <option value="technology" <?php echo e(request('sector') == 'technology' ? 'selected' : ''); ?>>Technology</option>
                                    <option value="finance" <?php echo e(request('sector') == 'finance' ? 'selected' : ''); ?>>Finance & Banking</option>
                                    <option value="healthcare" <?php echo e(request('sector') == 'healthcare' ? 'selected' : ''); ?>>Healthcare</option>
                                    <option value="education" <?php echo e(request('sector') == 'education' ? 'selected' : ''); ?>>Education</option>
                                    <option value="retail" <?php echo e(request('sector') == 'retail' ? 'selected' : ''); ?>>Retail & Commerce</option>
                                    <option value="logistics" <?php echo e(request('sector') == 'logistics' ? 'selected' : ''); ?>>Logistics</option>
                                    <option value="manufacturing" <?php echo e(request('sector') == 'manufacturing' ? 'selected' : ''); ?>>Manufacturing</option>
                                    <option value="construction" <?php echo e(request('sector') == 'construction' ? 'selected' : ''); ?>>Construction</option>
                                    <option value="agriculture" <?php echo e(request('sector') == 'agriculture' ? 'selected' : ''); ?>>Agriculture</option>
                                    <option value="energy" <?php echo e(request('sector') == 'energy' ? 'selected' : ''); ?>>Energy & Utilities</option>
                                    <option value="government" <?php echo e(request('sector') == 'government' ? 'selected' : ''); ?>>Government</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="bg-white/40 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-white/50">
                        <div class="flex gap-4 justify-center">
                            <button type="submit" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold px-8 py-4 rounded-xl transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 hover:-translate-y-1 flex items-center">
                                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                </svg>
                                Search Companies
                            </button>
                            <a href="<?php echo e(route('companies.index')); ?>" class="bg-white/80 hover:bg-white text-gray-700 hover:text-gray-900 px-6 py-4 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105 flex items-center backdrop-blur-sm border border-gray-200">
                                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                </svg>
                                Clear All
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Results Summary -->
    <div class="bg-white rounded-2xl shadow-lg p-6 mb-6">
        <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-4">
            <div class="flex-1">
                <div class="text-gray-900 text-lg font-semibold mb-2">
                    <span class="text-2xl"><?php echo e($companies->total()); ?></span> companies found
                    <?php if(request('q')): ?>
                    for "<span class="text-purple-600 font-bold"><?php echo e(request('q')); ?></span>"
                    <?php endif; ?>
                </div>
                <div class="flex flex-wrap items-center gap-4 text-sm text-gray-600">
                    <?php if(request('location')): ?>
                        <span class="flex items-center">
                            <svg class="w-4 h-4 mr-1 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <?php echo e(ucfirst(request('location'))); ?>

                        </span>
                    <?php endif; ?>
                    <?php if(request('sector')): ?>
                        <span class="flex items-center">
                            <svg class="w-4 h-4 mr-1 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                            </svg>
                            <?php echo e(ucfirst(request('sector'))); ?>

                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php if(request()->hasAny(['q', 'location', 'sector'])): ?>
        <div class="mt-4 pt-4 border-t border-gray-200">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-gray-700 mr-2">Active filters:</span>
                <?php if(request('q')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm bg-purple-100 text-purple-800">
                        "<?php echo e(request('q')); ?>"
                        <a href="<?php echo e(route('companies.index', array_merge(request()->all(), ['q' => null]))); ?>" class="ml-2 text-purple-600 hover:text-purple-800">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </a>
                    </span>
                <?php endif; ?>
                <?php if(request('location')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm bg-green-100 text-green-800">
                        <?php echo e(ucfirst(request('location'))); ?>

                        <a href="<?php echo e(route('companies.index', array_merge(request()->all(), ['location' => null]))); ?>" class="ml-2 text-green-600 hover:text-green-800">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </a>
                    </span>
                <?php endif; ?>
                <?php if(request('sector')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm bg-blue-100 text-blue-800">
                        <?php echo e(ucfirst(request('sector'))); ?>

                        <a href="<?php echo e(route('companies.index', array_merge(request()->all(), ['sector' => null]))); ?>" class="ml-2 text-blue-600 hover:text-blue-800">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </a>
                    </span>
                <?php endif; ?>
                <a href="<?php echo e(route('companies.index')); ?>" class="text-sm text-gray-500 hover:text-gray-700 underline ml-2">
                    Clear all filters
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Companies Grid -->
    <div class="max-w-7xl mx-auto">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <!-- Simplified Company Card -->
            <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden hover:shadow-lg transition-all duration-200 flex flex-col h-full">
                <!-- Card Header -->
                <div class="p-4 bg-gray-50 border-b border-gray-100">
                    <div class="flex items-center space-x-3">
                        <!-- Company Logo -->
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-yellow-400 to-yellow-500 flex items-center justify-center flex-shrink-0">
                            <?php if($company->logo): ?>
                                <img src="<?php echo e(asset('storage/' . $company->logo)); ?>" alt="<?php echo e($company->name); ?>" class="w-12 h-12 rounded-full object-cover">
                            <?php else: ?>
                                <span class="text-black font-bold text-lg"><?php echo e(substr($company->name, 0, 1)); ?></span>
                            <?php endif; ?>
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900 hover:text-yellow-600 cursor-pointer" onclick="window.location.href='<?php echo e(route('companies.show', $company)); ?>'">
                                <?php echo e($company->name); ?>

                            </h4>
                            <p class="text-sm text-gray-600"><?php echo e($company->sector ?? 'Industry'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="p-4 flex-1 flex flex-col">
                    <!-- Company Description -->
                    <p class="text-gray-700 mb-4 text-sm leading-relaxed line-clamp-3">
                        <?php echo e(Str::limit($company->description ?? 'A leading company in Cameroon.', 80)); ?>

                    </p>

                    <!-- Company Info -->
                    <div class="space-y-2 mb-4">
                        <div class="flex items-center text-sm text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <?php echo e($company->location ?? 'Cameroon'); ?>

                        </div>
                        <div class="flex items-center text-sm text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                            </svg>
                            <?php echo e($company->jobs_count ?? 0); ?> open positions
                        </div>
                    </div>

                    <!-- Company Tags -->
                    <div class="flex flex-wrap gap-2 mb-4">
                        <?php if($company->size): ?>
                        <span class="px-3 py-1 bg-blue-100 text-blue-800 text-xs rounded-full font-medium">
                            <?php echo e($company->size); ?>

                        </span>
                        <?php endif; ?>
                        <?php if($company->founded_year): ?>
                        <span class="px-3 py-1 bg-purple-100 text-purple-800 text-xs rounded-full font-medium">
                            Founded <?php echo e($company->founded_year); ?>

                        </span>
                        <?php endif; ?>
                    </div>

                    <!-- Spacer -->
                    <div class="flex-1"></div>

                    <!-- Card Footer -->
                    <div class="pt-4 border-t border-gray-100">
                        <a href="<?php echo e(route('companies.show', $company)); ?>" class="w-full bg-yellow-400 hover:bg-yellow-500 text-black py-2.5 rounded-lg font-semibold transition-colors inline-flex items-center justify-center text-sm">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            View Profile
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-white rounded-3xl shadow-2xl p-16 text-center col-span-full">
                <div class="w-32 h-32 bg-gradient-to-br from-gray-200 to-gray-300 rounded-full flex items-center justify-center mx-auto mb-8">
                    <svg class="w-16 h-16 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-4">No companies found</h3>
                <p class="text-xl text-gray-600 mb-8 max-w-md mx-auto">Try adjusting your search criteria or check back later for new companies.</p>
                <a href="<?php echo e(route('companies.index')); ?>" class="bg-gradient-to-r from-purple-600 to-indigo-700 hover:from-purple-700 hover:to-indigo-800 text-white font-bold px-8 py-4 rounded-xl transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 hover:-translate-y-1">
                    Clear Filters
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Pagination -->
    <?php if($companies->hasPages()): ?>
    <div class="mt-8">
        <?php echo e($companies->appends(request()->query())->links()); ?>

    </div>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc73518e4e557af3c08494b658146df84390e8f3a)): ?>
<?php $component = $__componentOriginalc73518e4e557af3c08494b658146df84390e8f3a; ?>
<?php unset($__componentOriginalc73518e4e557af3c08494b658146df84390e8f3a); ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/companies/index.blade.php ENDPATH**/ ?>