

<?php $__env->startSection('title', 'About – HireCameroon'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-black text-white py-24">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <div class="inline-flex items-center px-4 py-2 bg-yellow-400 border border-yellow-400 rounded-full text-sm font-medium mb-8 text-black">
                    <span class="w-2 h-2 bg-black rounded-full mr-2"></span>
                    Founded in Douala, Cameroon
                </div>

                <h1 class="text-6xl md:text-8xl font-black mb-8 leading-none text-white">
                    About <span class="text-yellow-400">HireCameroon</span>
                </h1>

                <p class="text-2xl md:text-3xl text-gray-300 max-w-4xl mx-auto leading-relaxed mb-8">
                    Revolutionizing <span class="font-bold text-yellow-400">Cameroon's</span> job market with
                    <span class="font-bold text-white">technology</span>,
                    <span class="font-bold text-gray-300">innovation</span>, and
                    <span class="font-bold text-yellow-400">passion</span>
                </p>

                <p class="text-lg text-gray-400 max-w-3xl mx-auto">
                    We're not just a job platform – we're building the future of work in Central Africa,
                    one meaningful connection at a time.
                </p>
            </div>
        </div>
    </section>

    <!-- What We Do Section -->
    <section class="py-24 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold text-black mb-6">What We Do</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    We connect talent with opportunity through innovative technology and deep market understanding
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- Job Matching -->
                <div class="bg-gray-50 p-8 rounded-lg border border-gray-200">
                    <div class="w-16 h-16 bg-yellow-400 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-black mb-4">Smart Job Matching</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Our AI-powered algorithm matches candidates with jobs based on skills, experience, location, and cultural fit, ensuring the best possible connections.
                    </p>
                </div>

                <!-- Company Solutions -->
                <div class="bg-gray-50 p-8 rounded-lg border border-gray-200">
                    <div class="w-16 h-16 bg-black rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-black mb-4">Company Solutions</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Comprehensive recruitment tools including job posting, candidate tracking, analytics, and advertising solutions tailored for Cameroonian businesses.
                    </p>
                </div>

                <!-- Community Building -->
                <div class="bg-gray-50 p-8 rounded-lg border border-gray-200">
                    <div class="w-16 h-16 bg-yellow-400 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-black mb-4">Community Building</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Creating a supportive ecosystem where job seekers and employers can thrive, with educational resources and networking opportunities.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Who We Are Section -->
    <section class="py-24 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold text-black mb-6">Who We Are</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    A passionate team of Cameroonian innovators dedicated to transforming the job market
                </p>
            </div>

            <div class="grid md:grid-cols-2 gap-12 items-center">
                <div>
                    <h3 class="text-3xl font-bold text-black mb-6">Our Story</h3>
                    <p class="text-gray-700 leading-relaxed mb-6">
                        Founded in 2025, HireCameroon emerged from a simple conversation between two friends who recognized
                        the gap in Cameroon's job market. What started as a social media discussion has become the leading
                        job platform in Central Africa.
                    </p>
                    <p class="text-gray-700 leading-relaxed mb-6">
                        We understand the unique challenges of the Cameroonian job market – from language barriers to
                        payment preferences. Our platform is built specifically for our community, incorporating local
                        context into every feature.
                    </p>
                    <p class="text-gray-700 leading-relaxed">
                        Today, we serve thousands of job seekers and hundreds of companies, creating meaningful
                        connections that drive economic growth and professional development across Cameroon.
                    </p>
                </div>

                <div class="bg-white p-8 rounded-lg shadow-lg">
                    <h4 class="text-2xl font-bold text-black mb-6">Our Values</h4>
                    <div class="space-y-4">
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-yellow-400 rounded-full mr-4"></div>
                            <span class="text-gray-700 font-medium">Innovation with Purpose</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-black rounded-full mr-4"></div>
                            <span class="text-gray-700 font-medium">Community First</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-yellow-400 rounded-full mr-4"></div>
                            <span class="text-gray-700 font-medium">Cultural Respect</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-black rounded-full mr-4"></div>
                            <span class="text-gray-700 font-medium">Transparency</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="py-24 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold text-black mb-6">Our Team</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Meet the visionaries behind HireCameroon
                </p>
            </div>

            <div class="grid md:grid-cols-2 gap-12 max-w-4xl mx-auto">
                <!-- CEO -->
                <div class="text-center">
                    <div class="w-32 h-32 bg-black rounded-full mx-auto mb-6 flex items-center justify-center">
                        <span class="text-3xl font-bold text-yellow-400">NE</span>
                    </div>
                    <h3 class="text-2xl font-bold text-black mb-2">Ngaw Elvis</h3>
                    <p class="text-yellow-400 font-semibold mb-4">Co-Founder & CEO</p>
                    <p class="text-gray-700 leading-relaxed">
                        Visionary leader with deep understanding of Cameroon's tech ecosystem.
                        His passion for empowering local talent drives our mission.
                    </p>
                </div>

                <!-- CTO -->
                <div class="text-center">
                    <div class="w-32 h-32 bg-yellow-400 rounded-full mx-auto mb-6 flex items-center justify-center">
                        <span class="text-3xl font-bold text-black">AM</span>
                    </div>
                    <h3 class="text-2xl font-bold text-black mb-2">Aloah Milton</h3>
                    <p class="text-black font-semibold mb-4">Co-Founder & CTO</p>
                    <p class="text-gray-700 leading-relaxed">
                        Technical architect specializing in mobile-first design and payment integration.
                        His expertise shapes our cutting-edge technology stack.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Support Section -->
    <section class="py-24 bg-black text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">How You Can Support Us</h2>
                <p class="text-xl text-gray-300 max-w-3xl mx-auto">
                    Join our mission to transform Cameroon's job market
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- For Job Seekers -->
                <div class="bg-gray-900 p-8 rounded-lg border border-gray-700">
                    <div class="w-16 h-16 bg-yellow-400 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-white mb-4">For Job Seekers</h3>
                    <p class="text-gray-300 leading-relaxed mb-6">
                        Create your profile, upload your resume, and let our AI match you with the perfect opportunities.
                        Join thousands of successful professionals who found their dream jobs through HireCameroon.
                    </p>
                    <a href="/register" class="inline-block bg-yellow-400 text-black font-bold py-3 px-6 rounded-lg hover:bg-yellow-300 transition">
                        Join as Job Seeker
                    </a>
                </div>

                <!-- For Companies -->
                <div class="bg-gray-900 p-8 rounded-lg border border-gray-700">
                    <div class="w-16 h-16 bg-white rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-white mb-4">For Companies</h3>
                    <p class="text-gray-300 leading-relaxed mb-6">
                        Post jobs, access top talent, and use our advertising platform to reach qualified candidates.
                        Join leading Cameroonian companies who trust HireCameroon for their recruitment needs.
                    </p>
                    <a href="/register" class="inline-block bg-white text-black font-bold py-3 px-6 rounded-lg hover:bg-gray-200 transition">
                        Join as Company
                    </a>
                </div>

                <!-- Support Our Mission -->
                <div class="bg-gray-900 p-8 rounded-lg border border-gray-700">
                    <div class="w-16 h-16 bg-yellow-400 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-white mb-4">Support Our Mission</h3>
                    <p class="text-gray-300 leading-relaxed mb-6">
                        Share our platform, provide feedback, or spread the word about HireCameroon.
                        Every connection we make helps build a stronger, more prosperous Cameroon.
                    </p>
                    <a href="/contact" class="inline-block bg-yellow-400 text-black font-bold py-3 px-6 rounded-lg hover:bg-yellow-300 transition">
                        Get in Touch
                    </a>
                </div>
            </div>
        </div>
    </section>


    <!-- CTA Section -->
    <section class="py-24 bg-gradient-to-br from-brand-navy via-slate-800 to-slate-900 relative overflow-hidden">
        <div class="absolute inset-0 bg-black/40"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.05"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-50"></div>
        <div class="relative max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl md:text-5xl font-black text-white mb-6">Join the HireCameroon Community</h2>
            <p class="text-xl md:text-2xl text-slate-200 mb-10 max-w-3xl mx-auto leading-relaxed">
                Whether you're looking for your next opportunity or seeking top talent,
                we're here to help you succeed in Cameroon's growing job market.
            </p>
            <div class="flex flex-col sm:flex-row gap-6 justify-center items-center">
                <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center px-10 py-5 bg-gradient-to-r from-brand-gold to-orange-500 text-white font-bold text-lg rounded-2xl transition-all duration-300 shadow-2xl hover:shadow-3xl transform hover:-translate-y-2 hover:from-brand-gold/90 hover:to-orange-600">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    Get Started Today
                </a>
                <a href="/contact" class="inline-flex items-center px-10 py-5 bg-white/15 backdrop-blur-sm border-2 border-white/30 text-white font-bold text-lg rounded-2xl transition-all duration-300 hover:bg-white/25 hover:border-white/50 hover:transform hover:-translate-y-1">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    Contact Us
                </a>
            </div>
            <div class="mt-12 pt-8 border-t border-white/20">
                <p class="text-slate-300 text-lg">
                    <span class="inline-flex items-center">
                        <svg class="w-5 h-5 mr-2 text-brand-gold" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        Trusted by 15,000+ job seekers and 2,500+ companies
                    </span>
                </p>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.marketing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/marketing/about.blade.php ENDPATH**/ ?>