<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'HireCameroon')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Favicon -->
        <link rel="icon" type="image/png" href="<?php echo e(asset('assets/brand/logo.png')); ?>">

        <!-- Scripts -->
        <!-- Production assets -->
        <link rel="stylesheet" href="/build/assets/app-0504b4a9.css">
        <script type="module" src="/build/assets/app-4fed7f7e.js"></script>

        <!-- Custom Styles -->
        <style>
            @keyframes slideIn {
                0% { transform: translateX(-100%) translateY(-50%); }
                100% { transform: translateX(0) translateY(-50%); }
            }
            @keyframes pulse {
                0% { transform: translateY(-50%) scale(1); }
                50% { transform: translateY(-50%) scale(1.05); }
                100% { transform: translateY(-50%) scale(1); }
            }
            .floating-ad-button {
                animation: slideIn 0.5s ease-out forwards, pulse 2s ease-in-out 1s 1;
            }
            @media (max-width: 640px) {
                .floating-ad-button {
                    padding: 0.75rem !important;
                }
                .floating-ad-button span {
                    display: none;
                }
                .floating-ad-button:hover {
                    padding: 0.75rem !important;
                }
            }
        </style>
    </head>
    <body class="font-sans antialiased">
        <!-- Floating Ads Button with proper z-index management -->
        <div class="fixed left-0 top-1/2 -translate-y-1/2 z-40 group" style="margin-left: 0;">
            <button onclick="window.location.href='/ads/create'"
               class="floating-ad-button flex items-center bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-4 py-3 rounded-r-lg shadow-xl transition-all duration-300 hover:px-6 relative hover:shadow-2xl">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                </svg>
                <span class="font-semibold">Post an Ad</span>
                
                <!-- Tooltip -->
                <div class="hidden group-hover:block absolute left-full ml-2 px-3 py-2 bg-gray-800 text-white text-sm rounded whitespace-nowrap shadow-lg z-50">
                    <div class="absolute left-0 top-1/2 transform -translate-x-1/2 -translate-y-1/2">
                        <div class="border-8 border-transparent border-r-gray-800"></div>
                    </div>
                    Boost your visibility! Create an advertisement
                </div>
            </button>
        </div>
        
        <div class="min-h-screen bg-gray-100 relative z-0">
            <?php if(auth()->guard()->check()): ?>
                <?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <!-- Page Heading -->
            <?php if(isset($header)): ?>
                <header class="bg-white shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        <?php echo e($header); ?>

                    </div>
                </header>
            <?php endif; ?>

            <!-- Page Content -->
            <main>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/layouts/app.blade.php ENDPATH**/ ?>